/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.builder;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.option.Switch;
import org.apache.commons.cli2.resource.ResourceHelper;

public class SwitchBuilder {
    private final String enabledPrefix;
    private final String disabledPrefix;
    private String description;
    private String preferredName;
    private Set aliases;
    private boolean required;
    private Argument argument;
    private Group children;
    private int id;
    private Boolean switchDefault;

    public SwitchBuilder() {
        this("+", "-");
    }

    public SwitchBuilder(String enabledPrefix, String disabledPrefix) throws IllegalArgumentException {
        if (enabledPrefix == null || enabledPrefix.length() < 1) {
            throw new IllegalArgumentException(ResourceHelper.getResourceHelper().getMessage("Option.illegal.enabled.prefix"));
        }
        if (disabledPrefix == null || disabledPrefix.length() < 1) {
            throw new IllegalArgumentException(ResourceHelper.getResourceHelper().getMessage("Option.illegal.disabled.prefix"));
        }
        if (enabledPrefix.equals(disabledPrefix)) {
            throw new IllegalArgumentException(ResourceHelper.getResourceHelper().getMessage("Option.identical.prefixes"));
        }
        this.enabledPrefix = enabledPrefix;
        this.disabledPrefix = disabledPrefix;
        this.reset();
    }

    public Switch create() {
        Switch option = new Switch(this.enabledPrefix, this.disabledPrefix, this.preferredName, this.aliases, this.description, this.required, this.argument, this.children, this.id, this.switchDefault);
        this.reset();
        return option;
    }

    public SwitchBuilder reset() {
        this.description = null;
        this.preferredName = null;
        this.required = false;
        this.aliases = new HashSet();
        this.argument = null;
        this.children = null;
        this.id = 0;
        this.switchDefault = null;
        return this;
    }

    public SwitchBuilder withDescription(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public SwitchBuilder withName(String name) {
        if (this.preferredName == null) {
            this.preferredName = name;
        } else {
            this.aliases.add(name);
        }
        return this;
    }

    public SwitchBuilder withRequired(boolean newRequired) {
        this.required = newRequired;
        return this;
    }

    public SwitchBuilder withArgument(Argument newArgument) {
        this.argument = newArgument;
        return this;
    }

    public SwitchBuilder withChildren(Group newChildren) {
        this.children = newChildren;
        return this;
    }

    public final SwitchBuilder withId(int newId) {
        this.id = newId;
        return this;
    }

    public final SwitchBuilder withSwitchDefault(Boolean newSwitchDefault) {
        this.switchDefault = newSwitchDefault;
        return this;
    }
}

