/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import java.util.Vector;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.util.AxisUtil;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.WSHandlerConstants;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.WSAddTimestamp;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.message.WSSAddSAMLToken;
import org.apache.ws.security.message.WSSAddUsernameToken;
import org.apache.ws.security.message.WSSignEnvelope;
import org.apache.ws.security.saml.SAMLIssuer;
import org.apache.ws.security.saml.SAMLIssuerFactory;
import org.apache.ws.security.util.StringUtil;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.XMLUtils;
import org.opensaml.SAMLAssertion;
import org.w3c.dom.Document;

public class WSDoAllSender
extends BasicHandler {
    static Log log = LogFactory.getLog((class$org$apache$ws$axis$security$WSDoAllSender == null ? (class$org$apache$ws$axis$security$WSDoAllSender = WSDoAllSender.class$("org.apache.ws.axis.security.WSDoAllSender")) : class$org$apache$ws$axis$security$WSDoAllSender).getName());
    static final WSSecurityEngine secEngine = WSSecurityEngine.getInstance();
    private static boolean doDebug = true;
    private static Hashtable cryptos = new Hashtable(5);
    static /* synthetic */ Class class$org$apache$ws$axis$security$WSDoAllSender;

    private RequestData initialize() {
        RequestData reqData = new RequestData();
        return reqData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext mc) throws AxisFault {
        doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug("WSDoAllSender: enter invoke() with msg type: " + mc.getCurrentMessage().getMessageType());
        }
        RequestData reqData = this.initialize();
        reqData.noSerialization = false;
        reqData.msgContext = mc;
        try {
            Vector actions2 = new Vector();
            String action = null;
            action = (String)this.getOption("action");
            if (action == null) {
                action = (String)reqData.msgContext.getProperty("action");
            }
            if (action == null) {
                throw new AxisFault("WSDoAllReceiver: No action defined");
            }
            int doAction = AxisUtil.decodeAction(action, actions2);
            if (doAction == 0) {
                return;
            }
            boolean mu = this.decodeMustUnderstand(reqData);
            reqData.actor = (String)this.getOption("actor");
            if (reqData.actor == null) {
                reqData.actor = (String)reqData.msgContext.getProperty("actor");
            }
            reqData.username = (String)this.getOption("user");
            if (reqData.username == null || reqData.username.equals("")) {
                String username = (String)reqData.msgContext.getProperty("user");
                if (username != null) {
                    reqData.username = username;
                } else {
                    reqData.username = reqData.msgContext.getUsername();
                    reqData.msgContext.setUsername(null);
                }
            }
            if ((doAction & 0x43) != 0 && (reqData.username == null || reqData.username.equals(""))) {
                throw new AxisFault("WSDoAllSender: Empty username for specified action");
            }
            if (doDebug) {
                log.debug("Action: " + doAction);
                log.debug("Actor: " + reqData.actor + ", mu: " + mu);
            }
            Document doc = null;
            Message message = reqData.msgContext.getCurrentMessage();
            SOAPPart sPart = (SOAPPart)message.getSOAPPart();
            doc = (Document)reqData.msgContext.getProperty("SND_SECURTIY");
            if (doc == null) {
                try {
                    doc = ((SOAPEnvelope)sPart.getEnvelope()).getAsDocument();
                }
                catch (Exception e) {
                    throw new AxisFault("WSDoAllSender: cannot get SOAP envlope from message" + e);
                }
            }
            reqData.soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
            if ((doAction & 1) == 1) {
                this.decodeUTParameter(reqData);
            }
            if ((doAction & 0x40) == 64) {
                this.decodeUTParameter(reqData);
                this.decodeSignatureParameter(reqData);
            }
            if ((doAction & 2) == 2) {
                reqData.sigCrypto = this.loadSignatureCrypto(reqData);
                this.decodeSignatureParameter(reqData);
            }
            if ((doAction & 0x10) == 16) {
                this.decodeSignatureParameter(reqData);
            }
            if ((doAction & 4) == 4) {
                reqData.encCrypto = this.loadEncryptionCrypto(reqData);
                this.decodeEncryptionParameter(reqData);
            }
            block18: for (int i = 0; i < actions2.size(); ++i) {
                int actionToDo = (Integer)actions2.get(i);
                if (doDebug) {
                    log.debug("Performing Action: " + actionToDo);
                }
                Object password = null;
                switch (actionToDo) {
                    case 1: {
                        this.performUTAction(actionToDo, mu, doc, reqData);
                        continue block18;
                    }
                    case 4: {
                        this.performENCRAction(mu, actionToDo, doc, reqData);
                        continue block18;
                    }
                    case 2: {
                        this.performSIGNAction(actionToDo, mu, doc, reqData);
                        continue block18;
                    }
                    case 16: {
                        this.performST_SIGNAction(actionToDo, mu, doc, reqData);
                        continue block18;
                    }
                    case 8: {
                        this.performSTAction(actionToDo, mu, doc, reqData);
                        continue block18;
                    }
                    case 32: {
                        this.performTSAction(actionToDo, mu, doc, reqData);
                        continue block18;
                    }
                    case 64: {
                        this.performUT_SIGNAction(actionToDo, mu, doc, reqData);
                        continue block18;
                    }
                    case 256: {
                        reqData.noSerialization = true;
                    }
                }
            }
            if (reqData.noSerialization) {
                reqData.msgContext.setProperty("SND_SECURTIY", doc);
            } else {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLUtils.outputDOM(doc, os, true);
                sPart.setCurrentMessage(os.toByteArray(), 4);
                if (doDebug) {
                    String osStr = null;
                    try {
                        osStr = os.toString("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        osStr = os.toString();
                    }
                    log.debug("Send request:");
                    log.debug(osStr);
                }
                reqData.msgContext.setProperty("SND_SECURTIY", null);
            }
            if (doDebug) {
                log.debug("WSDoAllSender: exit invoke()");
            }
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }

    private void performSIGNAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws AxisFault {
        String password = this.getPassword(reqData.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
        WSSignEnvelope wsSign = new WSSignEnvelope(reqData.actor, mu);
        if (reqData.sigKeyId != 0) {
            wsSign.setKeyIdentifierType(reqData.sigKeyId);
        }
        if (reqData.sigAlgorithm != null) {
            wsSign.setSignatureAlgorithm(reqData.sigAlgorithm);
        }
        wsSign.setUserInfo(reqData.username, password);
        if (reqData.signatureParts.size() > 0) {
            wsSign.setParts(reqData.signatureParts);
        }
        try {
            wsSign.build(doc, reqData.sigCrypto);
        }
        catch (WSSecurityException e) {
            throw new AxisFault("WSDoAllSender: Signature: error during message procesing" + e);
        }
    }

    private void performENCRAction(boolean mu, int actionToDo, Document doc, RequestData reqData) throws AxisFault {
        WSEncryptBody wsEncrypt = new WSEncryptBody(reqData.actor, mu);
        if (reqData.encKeyId != 0) {
            wsEncrypt.setKeyIdentifierType(reqData.encKeyId);
        }
        if (reqData.encKeyId == 5) {
            String encKeyName = null;
            encKeyName = (String)this.getOption("EmbeddedKeyName");
            if (encKeyName == null) {
                encKeyName = (String)reqData.msgContext.getProperty("EmbeddedKeyName");
            }
            wsEncrypt.setEmbeddedKeyName(encKeyName);
            byte[] embeddedKey = this.getPassword(reqData.encUser, actionToDo, "EmbeddedKeyCallbackClass", "EmbeddedKeyCallbackRef", reqData).getKey();
            wsEncrypt.setKey(embeddedKey);
        }
        if (reqData.encSymmAlgo != null) {
            wsEncrypt.setSymmetricEncAlgorithm(reqData.encSymmAlgo);
        }
        if (reqData.encKeyTransport != null) {
            wsEncrypt.setKeyEnc(reqData.encKeyTransport);
        }
        wsEncrypt.setUserInfo(reqData.encUser);
        wsEncrypt.setUseThisCert(reqData.encCert);
        if (reqData.encryptParts.size() > 0) {
            wsEncrypt.setParts(reqData.encryptParts);
        }
        try {
            wsEncrypt.build(doc, reqData.encCrypto);
        }
        catch (WSSecurityException e) {
            throw new AxisFault("WSDoAllSender: Encryption: error during message processing" + e);
        }
    }

    private void performUTAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws AxisFault {
        String password = this.getPassword(reqData.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
        WSSAddUsernameToken builder = new WSSAddUsernameToken(reqData.actor, mu);
        builder.setPasswordType(reqData.pwType);
        builder.build(doc, reqData.username, password);
        if (reqData.utElements != null && reqData.utElements.length > 0) {
            for (int j = 0; j < reqData.utElements.length; ++j) {
                reqData.utElements[j].trim();
                if (reqData.utElements[j].equals("Nonce")) {
                    builder.addNonce(doc);
                }
                if (reqData.utElements[j].equals("Created")) {
                    builder.addCreated(doc);
                }
                reqData.utElements[j] = null;
            }
        }
    }

    private void performUT_SIGNAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws AxisFault {
        String password = this.getPassword(reqData.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
        WSSAddUsernameToken builder = new WSSAddUsernameToken(reqData.actor, mu);
        builder.setPasswordType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText");
        builder.preSetUsernameToken(doc, reqData.username, password);
        builder.addCreated(doc);
        builder.addNonce(doc);
        WSSignEnvelope sign = new WSSignEnvelope(reqData.actor, mu);
        if (reqData.signatureParts.size() > 0) {
            sign.setParts(reqData.signatureParts);
        }
        sign.setUsernameToken(builder);
        sign.setKeyIdentifierType(7);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        try {
            sign.build(doc, null);
        }
        catch (WSSecurityException e) {
            throw new AxisFault("WSDoAllSender: Error during Signatur with UsernameToken secret" + e);
        }
        builder.build(doc, null, null);
    }

    private void performSTAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws AxisFault {
        WSSAddSAMLToken builder = new WSSAddSAMLToken(reqData.actor, mu);
        String samlPropFile = null;
        samlPropFile = (String)this.getOption("samlPropFile");
        if (samlPropFile == null) {
            samlPropFile = (String)reqData.msgContext.getProperty("samlPropFile");
        }
        SAMLIssuer saml = SAMLIssuerFactory.getInstance(samlPropFile);
        saml.setUsername(reqData.username);
        SAMLAssertion assertion = saml.newAssertion();
        builder.build(doc, assertion);
    }

    private void performST_SIGNAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws AxisFault {
        String samlPropFile = null;
        samlPropFile = (String)this.getOption("samlPropFile");
        if (samlPropFile == null) {
            samlPropFile = (String)reqData.msgContext.getProperty("samlPropFile");
        }
        Crypto crypto = null;
        try {
            crypto = this.loadSignatureCrypto(reqData);
        }
        catch (AxisFault ex) {
            // empty catch block
        }
        SAMLIssuer saml = SAMLIssuerFactory.getInstance(samlPropFile);
        saml.setUsername(reqData.username);
        saml.setUserCrypto(crypto);
        saml.setInstanceDoc(doc);
        SAMLAssertion assertion = saml.newAssertion();
        if (assertion == null) {
            throw new AxisFault("WSDoAllSender: Signed SAML: no SAML token received");
        }
        String issuerKeyName = null;
        String issuerKeyPW = null;
        Crypto issuerCrypto = null;
        WSSignEnvelope wsSign = new WSSignEnvelope(reqData.actor, mu);
        String password = null;
        if (saml.isSenderVouches()) {
            issuerKeyName = saml.getIssuerKeyName();
            issuerKeyPW = saml.getIssuerKeyPassword();
            issuerCrypto = saml.getIssuerCrypto();
        } else {
            password = this.getPassword(reqData.username, actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
            wsSign.setUserInfo(reqData.username, password);
        }
        if (reqData.sigKeyId != 0) {
            wsSign.setKeyIdentifierType(reqData.sigKeyId);
        }
        try {
            wsSign.build(doc, crypto, assertion, issuerCrypto, issuerKeyName, issuerKeyPW);
        }
        catch (WSSecurityException e) {
            throw new AxisFault("WSDoAllSender: Signed SAML: error during message processing" + e);
        }
    }

    private void performTSAction(int actionToDo, boolean mu, Document doc, RequestData reqData) throws AxisFault {
        String ttl = null;
        ttl = (String)this.getOption("timeToLive");
        if (ttl == null) {
            ttl = (String)reqData.msgContext.getProperty("timeToLive");
        }
        int ttl_i = 0;
        if (ttl != null) {
            try {
                ttl_i = Integer.parseInt(ttl);
            }
            catch (NumberFormatException e) {
                ttl_i = reqData.timeToLive;
            }
        }
        if (ttl_i <= 0) {
            ttl_i = reqData.timeToLive;
        }
        WSAddTimestamp timeStampBuilder = new WSAddTimestamp(reqData.actor, mu);
        timeStampBuilder.build(doc, ttl_i);
    }

    protected Crypto loadSignatureCrypto(RequestData reqData) throws AxisFault {
        Crypto crypto = null;
        String sigPropFile = null;
        sigPropFile = (String)this.getOption("signaturePropFile");
        if (sigPropFile == null) {
            sigPropFile = (String)reqData.msgContext.getProperty("signaturePropFile");
        }
        if (sigPropFile != null) {
            crypto = (Crypto)cryptos.get(sigPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(sigPropFile);
                cryptos.put(sigPropFile, crypto);
            }
        } else {
            throw new AxisFault("WSDoAllSender: Signature: no crypto property file");
        }
        return crypto;
    }

    protected Crypto loadEncryptionCrypto(RequestData reqData) throws AxisFault {
        Crypto crypto = null;
        String encPropFile = null;
        encPropFile = (String)this.getOption("encryptionPropFile");
        if (encPropFile == null) {
            encPropFile = (String)reqData.msgContext.getProperty("encryptionPropFile");
        }
        if (encPropFile != null) {
            crypto = (Crypto)cryptos.get(encPropFile);
            if (crypto == null) {
                crypto = CryptoFactory.getInstance(encPropFile);
                cryptos.put(encPropFile, crypto);
            }
        } else {
            crypto = reqData.sigCrypto;
            if (crypto == null) {
                throw new AxisFault("WSDoAllSender: Encryption: no crypto property file");
            }
        }
        return crypto;
    }

    private void decodeUTParameter(RequestData reqData) throws AxisFault {
        reqData.pwType = (String)this.getOption("passwordType");
        if (reqData.pwType == null) {
            reqData.pwType = (String)reqData.msgContext.getProperty("passwordType");
        }
        if (reqData.pwType != null) {
            reqData.pwType = reqData.pwType.equals("PasswordText") ? "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText" : "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest";
        }
        String tmpS = null;
        tmpS = (String)this.getOption("addUTElements");
        if (tmpS == null) {
            tmpS = (String)reqData.msgContext.getProperty("addUTElements");
        }
        if (tmpS != null) {
            reqData.utElements = StringUtil.split(tmpS, ' ');
        }
    }

    private void decodeSignatureParameter(RequestData reqData) throws AxisFault {
        String tmpS = null;
        tmpS = (String)this.getOption("signatureKeyIdentifier");
        if (tmpS == null) {
            tmpS = (String)reqData.msgContext.getProperty("signatureKeyIdentifier");
        }
        if (tmpS != null) {
            Integer I = (Integer)WSHandlerConstants.keyIdentifier.get(tmpS);
            if (I == null) {
                throw new AxisFault("WSDoAllSender: Signature: unknown key identification");
            }
            reqData.sigKeyId = I;
            if (reqData.sigKeyId != 2 && reqData.sigKeyId != 1 && reqData.sigKeyId != 3 && reqData.sigKeyId != 4) {
                throw new AxisFault("WSDoAllSender: Signature: illegal key identification");
            }
        }
        if ((reqData.sigAlgorithm = (String)this.getOption("signatureAlgorithm")) == null) {
            tmpS = (String)reqData.msgContext.getProperty("signatureAlgorithm");
        }
        if ((tmpS = (String)this.getOption("signatureParts")) == null) {
            tmpS = (String)reqData.msgContext.getProperty("signatureParts");
        }
        if (tmpS != null) {
            this.splitEncParts(tmpS, reqData.signatureParts, reqData);
        }
    }

    private void decodeEncryptionParameter(RequestData reqData) throws AxisFault {
        reqData.encUser = (String)this.getOption("encryptionUser");
        if (reqData.encUser == null) {
            reqData.encUser = (String)reqData.msgContext.getProperty("encryptionUser");
        }
        if (reqData.encUser == null && (reqData.encUser = reqData.username) == null) {
            throw new AxisFault("WSDoAllSender: Encryption: no username");
        }
        this.handleSpecialUser(reqData);
        String tmpS = null;
        tmpS = (String)this.getOption("encryptionKeyIdentifier");
        if (tmpS == null) {
            tmpS = (String)reqData.msgContext.getProperty("encryptionKeyIdentifier");
        }
        if (tmpS != null) {
            Integer I = (Integer)WSHandlerConstants.keyIdentifier.get(tmpS);
            if (I == null) {
                throw new AxisFault("WSDoAllSender: Encryption: unknown key identification");
            }
            reqData.encKeyId = I;
            if (reqData.encKeyId != 2 && reqData.encKeyId != 3 && reqData.encKeyId != 4 && reqData.encKeyId != 1 && reqData.encKeyId != 5) {
                throw new AxisFault("WSDoAllSender: Encryption: illegal key identification");
            }
        }
        if ((reqData.encSymmAlgo = (String)this.getOption("encryptionSymAlgorithm")) == null) {
            reqData.encSymmAlgo = (String)reqData.msgContext.getProperty("encryptionSymAlgorithm");
        }
        if ((reqData.encKeyTransport = (String)this.getOption("encryptionKeyTransportAlgorithm")) == null) {
            reqData.encKeyTransport = (String)reqData.msgContext.getProperty("encryptionKeyTransportAlgorithm");
        }
        if ((tmpS = (String)this.getOption("encryptionParts")) == null) {
            tmpS = (String)reqData.msgContext.getProperty("encryptionParts");
        }
        if (tmpS != null) {
            this.splitEncParts(tmpS, reqData.encryptParts, reqData);
        }
    }

    private boolean decodeMustUnderstand(RequestData reqData) throws AxisFault {
        boolean mu = true;
        String mustUnderstand = null;
        mustUnderstand = (String)this.getOption("mustUnderstand");
        if (mustUnderstand == null) {
            mustUnderstand = (String)reqData.msgContext.getProperty("mustUnderstand");
        }
        if (mustUnderstand != null) {
            if (mustUnderstand.equals("0") || mustUnderstand.equals("false")) {
                mu = false;
            } else if (mustUnderstand.equals("1") || mustUnderstand.equals("true")) {
                mu = true;
            } else {
                throw new AxisFault("WSDoAllSender: illegal mustUnderstand parameter");
            }
        }
        return mu;
    }

    private WSPasswordCallback getPassword(String username, int doAction, String clsProp, String refProp, RequestData reqData) throws AxisFault {
        WSPasswordCallback pwCb = null;
        String password = null;
        String callback = null;
        CallbackHandler cbHandler = null;
        callback = (String)this.getOption(clsProp);
        if (callback == null) {
            callback = (String)reqData.msgContext.getProperty(clsProp);
        }
        if (callback != null) {
            pwCb = this.readPwViaCallbackClass(callback, username, doAction);
            if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                throw new AxisFault("WSDoAllSender: password callback class provided null or empty password");
            }
        } else {
            cbHandler = (CallbackHandler)reqData.msgContext.getProperty(refProp);
            if (cbHandler != null) {
                pwCb = this.performCallback(cbHandler, username, doAction);
                if (pwCb.getPassword() == null && pwCb.getKey() == null) {
                    throw new AxisFault("WSDoAllSender: password callback provided null or empty password");
                }
            } else {
                password = reqData.msgContext.getPassword();
                if (password == null) {
                    throw new AxisFault("WSDoAllSender: application provided null or empty password");
                }
                reqData.msgContext.setPassword(null);
                pwCb = new WSPasswordCallback("", 0);
                pwCb.setPassword(password);
            }
        }
        return pwCb;
    }

    private WSPasswordCallback readPwViaCallbackClass(String callback, String username, int doAction) throws AxisFault {
        Class<?> cbClass = null;
        CallbackHandler cbHandler = null;
        try {
            cbClass = Class.forName(callback);
        }
        catch (ClassNotFoundException e) {
            throw new AxisFault("WSDoAllSender: cannot load password callback class: " + callback, e);
        }
        try {
            cbHandler = (CallbackHandler)cbClass.newInstance();
        }
        catch (Exception e) {
            throw new AxisFault("WSDoAllSender: cannot create instance of password callback: " + callback, e);
        }
        return this.performCallback(cbHandler, username, doAction);
    }

    private WSPasswordCallback performCallback(CallbackHandler cbHandler, String username, int doAction) throws AxisFault {
        WSPasswordCallback pwCb = null;
        int reason = 0;
        switch (doAction) {
            case 1: 
            case 64: {
                reason = 2;
                break;
            }
            case 2: {
                reason = 3;
                break;
            }
            case 4: {
                reason = 4;
            }
        }
        pwCb = new WSPasswordCallback(username, reason);
        Callback[] callbacks = new Callback[]{pwCb};
        try {
            cbHandler.handle(callbacks);
        }
        catch (Exception e) {
            throw new AxisFault("WSDoAllSender: password callback failed", e);
        }
        return pwCb;
    }

    private void splitEncParts(String tmpS, Vector parts, RequestData reqData) throws AxisFault {
        WSEncryptionPart encPart = null;
        String[] rawParts = StringUtil.split(tmpS, ';');
        for (int i = 0; i < rawParts.length; ++i) {
            String[] partDef = StringUtil.split(rawParts[i], '}');
            if (partDef.length == 1) {
                if (doDebug) {
                    log.debug("single partDef: '" + partDef[0] + "'");
                }
                encPart = new WSEncryptionPart(partDef[0].trim(), reqData.soapConstants.getEnvelopeURI(), "Content");
            } else if (partDef.length == 3) {
                String mode = partDef[0].trim();
                mode = mode.length() <= 1 ? "Content" : mode.substring(1);
                String nmSpace = partDef[1].trim();
                nmSpace = nmSpace.length() <= 1 ? reqData.soapConstants.getEnvelopeURI() : nmSpace.substring(1);
                String element = partDef[2].trim();
                if (doDebug) {
                    log.debug("partDefs: '" + mode + "' ,'" + nmSpace + "' ,'" + element + "'");
                }
                encPart = new WSEncryptionPart(element, nmSpace, mode);
            } else {
                throw new AxisFault("WSDoAllSender: wrong part definition: " + tmpS);
            }
            parts.add(encPart);
        }
    }

    private void handleSpecialUser(RequestData reqData) {
        if (!"useReqSigCert".equals(reqData.encUser)) {
            return;
        }
        Vector results = null;
        results = (Vector)reqData.msgContext.getProperty("RECV_RESULTS");
        if (results == null) {
            return;
        }
        for (int i = 0; i < results.size(); ++i) {
            WSHandlerResult rResult = (WSHandlerResult)results.get(i);
            String hActor = rResult.getActor();
            if (!WSSecurityUtil.isActorEqual(reqData.actor, hActor)) continue;
            Vector wsSecEngineResults = rResult.getResults();
            for (int j = 0; j < wsSecEngineResults.size(); ++j) {
                WSSecurityEngineResult wser = (WSSecurityEngineResult)wsSecEngineResults.get(j);
                if (wser.getAction() != 2) continue;
                reqData.encCert = wser.getCertificate();
                return;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RequestData {
        MessageContext msgContext = null;
        boolean noSerialization = false;
        SOAPConstants soapConstants = null;
        String actor = null;
        String username = null;
        String pwType = null;
        String[] utElements = null;
        Crypto sigCrypto = null;
        int sigKeyId = 0;
        String sigAlgorithm = null;
        Vector signatureParts = new Vector();
        Crypto encCrypto = null;
        int encKeyId = 0;
        String encSymmAlgo = null;
        String encKeyTransport = null;
        String encUser = null;
        Vector encryptParts = new Vector();
        X509Certificate encCert = null;
        int timeToLive = 300;

        private RequestData() {
        }

        void clear() {
            this.soapConstants = null;
            this.encUser = null;
            this.encKeyTransport = null;
            this.encSymmAlgo = null;
            this.sigAlgorithm = null;
            this.pwType = null;
            this.username = null;
            this.actor = null;
            this.encCrypto = null;
            this.sigCrypto = null;
            this.signatureParts.clear();
            this.encryptParts.clear();
            this.encryptParts = null;
            this.signatureParts = null;
            this.encCert = null;
            this.utElements = null;
        }
    }
}

