/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.c14n.implementations;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.CanonicalizerSpi;
import org.apache.xml.security.c14n.helper.AttrCompare;
import org.apache.xml.security.c14n.implementations.NameSpaceSymbTable;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    private static final byte[] _END_PI = new byte[]{63, 62};
    private static final byte[] _BEGIN_PI = new byte[]{60, 63};
    private static final byte[] _END_COMM = new byte[]{45, 45, 62};
    private static final byte[] _BEGIN_COMM = new byte[]{60, 33, 45, 45};
    private static final byte[] __XA_ = new byte[]{38, 35, 120, 65, 59};
    private static final byte[] __X9_ = new byte[]{38, 35, 120, 57, 59};
    private static final byte[] _QUOT_ = new byte[]{38, 113, 117, 111, 116, 59};
    private static final byte[] __XD_ = new byte[]{38, 35, 120, 68, 59};
    private static final byte[] _GT_ = new byte[]{38, 103, 116, 59};
    private static final byte[] _LT_ = new byte[]{38, 108, 116, 59};
    private static final byte[] _END_TAG = new byte[]{60, 47};
    private static final byte[] _AMP_ = new byte[]{38, 97, 109, 112, 59};
    static final AttrCompare COMPARE = new AttrCompare();
    static final String XML = "xml";
    static final String XMLNS = "xmlns";
    static final byte[] equalsStr = new byte[]{61, 34};
    static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    protected static final Attr nullNode;
    boolean _includeComments;
    Set _xpathNodeSet = null;
    Node _excludeNode = null;
    OutputStream _writer = new ByteArrayOutputStream();

    public CanonicalizerBase(boolean bl) {
        this._includeComments = bl;
    }

    public byte[] engineCanonicalizeSubTree(Node node) throws CanonicalizationException {
        return this.engineCanonicalizeSubTree(node, (Node)null);
    }

    public byte[] engineCanonicalizeSubTree(Node node, Node node2) throws CanonicalizationException {
        this._excludeNode = node2;
        try {
            NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
            if (node instanceof Element) {
                CanonicalizerBase.getParentNameSpaces((Element)node, nameSpaceSymbTable);
            }
            this.canonicalizeSubTree(node, nameSpaceSymbTable);
            this._writer.close();
            if (this._writer instanceof ByteArrayOutputStream) {
                byte[] byArray = ((ByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((ByteArrayOutputStream)this._writer).reset();
                }
                return byArray;
            }
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CanonicalizationException("empty", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new CanonicalizationException("empty", iOException);
        }
    }

    final void canonicalizeSubTree(Node node, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException, IOException {
        switch (node.getNodeType()) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.canonicalizeSubTree(node2, nameSpaceSymbTable);
                }
                break;
            }
            case 8: {
                if (!this._includeComments) break;
                CanonicalizerBase.outputCommentToWriter((Comment)node, this._writer);
                break;
            }
            case 7: {
                CanonicalizerBase.outputPItoWriter((ProcessingInstruction)node, this._writer);
                break;
            }
            case 3: 
            case 4: {
                CanonicalizerBase.outputTextToWriter(node.getNodeValue(), this._writer);
                break;
            }
            case 1: {
                Node node3;
                if (node == this._excludeNode) {
                    return;
                }
                OutputStream outputStream = this._writer;
                Element element = (Element)node;
                nameSpaceSymbTable.outputNodePush();
                outputStream.write(60);
                String string = element.getTagName();
                CanonicalizerBase.writeStringToUtf8(string, outputStream);
                Iterator iterator = this.handleAttributesSubtree(element, nameSpaceSymbTable);
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        node3 = (Attr)iterator.next();
                        CanonicalizerBase.outputAttrToWriter(node3.getNodeName(), node3.getNodeValue(), outputStream);
                    }
                }
                outputStream.write(62);
                for (node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    this.canonicalizeSubTree(node3, nameSpaceSymbTable);
                }
                outputStream.write(_END_TAG);
                CanonicalizerBase.writeStringToUtf8(string, outputStream);
                outputStream.write(62);
                nameSpaceSymbTable.outputNodePop();
            }
        }
    }

    static final int getPositionRelativeToDocumentElement(Node node) {
        if (node == null || node.getParentNode().getNodeType() != 9) {
            return 0;
        }
        Element element = node.getOwnerDocument().getDocumentElement();
        if (element == null || element == node) {
            return 0;
        }
        for (Node node2 = node; node2 != null; node2 = node2.getNextSibling()) {
            if (node2 != element) continue;
            return -1;
        }
        return 1;
    }

    public byte[] engineCanonicalizeXPathNodeSet(Set set) throws CanonicalizationException {
        if (set.size() == 0) {
            return new byte[0];
        }
        this._xpathNodeSet = set;
        try {
            Document document = XMLUtils.getOwnerDocument(this._xpathNodeSet);
            this.canonicalizeXPathNodeSet(document, new NameSpaceSymbTable());
            this._writer.close();
            if (this._writer instanceof ByteArrayOutputStream) {
                byte[] byArray = ((ByteArrayOutputStream)this._writer).toByteArray();
                if (this.reset) {
                    ((ByteArrayOutputStream)this._writer).reset();
                }
                return byArray;
            }
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CanonicalizationException("empty", unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new CanonicalizationException("empty", iOException);
        }
    }

    final void canonicalizeXPathNodeSet(Node node, NameSpaceSymbTable nameSpaceSymbTable) throws CanonicalizationException, IOException {
        boolean bl = this._xpathNodeSet.contains(node);
        switch (node.getNodeType()) {
            default: {
                break;
            }
            case 2: 
            case 6: 
            case 11: 
            case 12: {
                throw new CanonicalizationException("empty");
            }
            case 9: {
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(node2, nameSpaceSymbTable);
                }
                break;
            }
            case 8: {
                if (!bl || !this._includeComments) break;
                CanonicalizerBase.outputCommentToWriter((Comment)node, this._writer);
                break;
            }
            case 7: {
                if (!bl) break;
                CanonicalizerBase.outputPItoWriter((ProcessingInstruction)node, this._writer);
                break;
            }
            case 3: 
            case 4: {
                if (!bl) break;
                CanonicalizerBase.outputTextToWriter(node.getNodeValue(), this._writer);
                for (Node node3 = node.getNextSibling(); node3 != null && (node3.getNodeType() == 3 || node3.getNodeType() == 4); node3 = node3.getNextSibling()) {
                    CanonicalizerBase.outputTextToWriter(node3.getNodeValue(), this._writer);
                }
                break;
            }
            case 1: {
                Node node4;
                Element element = (Element)node;
                OutputStream outputStream = this._writer;
                String string = element.getTagName();
                if (bl) {
                    nameSpaceSymbTable.outputNodePush();
                    outputStream.write(60);
                    CanonicalizerBase.writeStringToUtf8(string, outputStream);
                } else {
                    nameSpaceSymbTable.push();
                }
                Iterator iterator = this.handleAttributes(element, nameSpaceSymbTable);
                while (iterator.hasNext()) {
                    node4 = (Attr)iterator.next();
                    CanonicalizerBase.outputAttrToWriter(node4.getNodeName(), node4.getNodeValue(), outputStream);
                }
                if (bl) {
                    outputStream.write(62);
                }
                for (node4 = node.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    this.canonicalizeXPathNodeSet(node4, nameSpaceSymbTable);
                }
                if (bl) {
                    outputStream.write(_END_TAG);
                    CanonicalizerBase.writeStringToUtf8(string, outputStream);
                    outputStream.write(62);
                    nameSpaceSymbTable.outputNodePop();
                    break;
                }
                nameSpaceSymbTable.pop();
            }
        }
    }

    static final void getParentNameSpaces(Element element, NameSpaceSymbTable nameSpaceSymbTable) {
        Node node;
        Object object;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Node node2 = element.getParentNode();
        if (!(node2 instanceof Element)) {
            return;
        }
        Element element2 = (Element)element.getParentNode();
        while (element2 != null) {
            arrayList.add(element2);
            object = element2.getParentNode();
            if (!(object instanceof Element)) break;
            element2 = (Element)object;
        }
        object = arrayList.listIterator(arrayList.size());
        while (object.hasPrevious()) {
            node = (Element)object.previous();
            if (!node.hasAttributes()) continue;
            NamedNodeMap namedNodeMap = node.getAttributes();
            int n = namedNodeMap.getLength();
            for (int i = 0; i < n; ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
                String string = attr.getLocalName();
                String string2 = attr.getNodeValue();
                if (XML.equals(string) && "http://www.w3.org/XML/1998/namespace".equals(string2)) continue;
                nameSpaceSymbTable.addMapping(string, string2, attr);
            }
        }
        node = nameSpaceSymbTable.getMappingWithoutRendered(XMLNS);
        if (node != null && "".equals(node.getValue())) {
            nameSpaceSymbTable.addMappingAndRender(XMLNS, "", nullNode);
        }
    }

    static final void outputAttrToWriter(String string, String string2, OutputStream outputStream) throws IOException {
        outputStream.write(32);
        CanonicalizerBase.writeStringToUtf8(string, outputStream);
        outputStream.write(equalsStr);
        int n = string2.length();
        block8: for (int i = 0; i < n; ++i) {
            byte[] byArray;
            char c = string2.charAt(i);
            switch (c) {
                case '&': {
                    byArray = _AMP_;
                    break;
                }
                case '<': {
                    byArray = _LT_;
                    break;
                }
                case '\"': {
                    byArray = _QUOT_;
                    break;
                }
                case '\t': {
                    byArray = __X9_;
                    break;
                }
                case '\n': {
                    byArray = __XA_;
                    break;
                }
                case '\r': {
                    byArray = __XD_;
                    break;
                }
                default: {
                    CanonicalizerBase.writeCharToUtf8(c, outputStream);
                    continue block8;
                }
            }
            outputStream.write(byArray);
        }
        outputStream.write(34);
    }

    static final void writeCharToUtf8(char c, OutputStream outputStream) throws IOException {
        if (c <= '\u007f') {
            outputStream.write(c);
            return;
        }
        if (c > '\u07ff') {
            char c2 = (char)(c >>> 12);
            if (c2 > '\u0000') {
                outputStream.write(0xE0 | c2 & 0xF);
            } else {
                outputStream.write(224);
            }
            outputStream.write(0x80 | c >>> 6 & 0x3F);
            outputStream.write(0x80 | c & 0x3F);
            return;
        }
        char c3 = (char)(c >>> 6);
        if (c3 > '\u0000') {
            outputStream.write(0xC0 | c3 & 0x1F);
        } else {
            outputStream.write(192);
        }
        outputStream.write(0x80 | c & 0x3F);
    }

    static final void writeStringToUtf8(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c;
            char c2;
            if ((c2 = string.charAt(n2++)) <= '\u007f') {
                outputStream.write(c2);
                continue;
            }
            if (c2 > '\u07ff') {
                c = (char)(c2 >>> 12);
                if (c > '\u0000') {
                    outputStream.write(0xE0 | c & 0xF);
                } else {
                    outputStream.write(224);
                }
                outputStream.write(0x80 | c2 >>> 6 & 0x3F);
                outputStream.write(0x80 | c2 & 0x3F);
                continue;
            }
            c = (char)(c2 >>> 6);
            if (c > '\u0000') {
                outputStream.write(0xC0 | c & 0x1F);
            } else {
                outputStream.write(192);
            }
            outputStream.write(0x80 | c2 & 0x3F);
        }
    }

    static final void outputPItoWriter(ProcessingInstruction processingInstruction, OutputStream outputStream) throws IOException {
        int n;
        int n2 = CanonicalizerBase.getPositionRelativeToDocumentElement(processingInstruction);
        if (n2 == 1) {
            outputStream.write(10);
        }
        outputStream.write(_BEGIN_PI);
        String string = processingInstruction.getTarget();
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n = string.charAt(i);
            if (n == 13) {
                outputStream.write(__XD_);
                continue;
            }
            CanonicalizerBase.writeCharToUtf8((char)n, outputStream);
        }
        String string2 = processingInstruction.getData();
        n3 = string2.length();
        if (n3 > 0) {
            outputStream.write(32);
            for (n = 0; n < n3; ++n) {
                char c = string2.charAt(n);
                if (c == '\r') {
                    outputStream.write(__XD_);
                    continue;
                }
                CanonicalizerBase.writeCharToUtf8(c, outputStream);
            }
        }
        outputStream.write(_END_PI);
        if (n2 == -1) {
            outputStream.write(10);
        }
    }

    static final void outputCommentToWriter(Comment comment, OutputStream outputStream) throws IOException {
        int n = CanonicalizerBase.getPositionRelativeToDocumentElement(comment);
        if (n == 1) {
            outputStream.write(10);
        }
        outputStream.write(_BEGIN_COMM);
        String string = comment.getData();
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '\r') {
                outputStream.write(__XD_);
                continue;
            }
            CanonicalizerBase.writeCharToUtf8(c, outputStream);
        }
        outputStream.write(_END_COMM);
        if (n == -1) {
            outputStream.write(10);
        }
    }

    static final void outputTextToWriter(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            byte[] byArray;
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    byArray = _AMP_;
                    break;
                }
                case '<': {
                    byArray = _LT_;
                    break;
                }
                case '>': {
                    byArray = _GT_;
                    break;
                }
                case '\r': {
                    byArray = __XD_;
                    break;
                }
                default: {
                    CanonicalizerBase.writeCharToUtf8(c, outputStream);
                    continue block6;
                }
            }
            outputStream.write(byArray);
        }
    }

    abstract Iterator handleAttributes(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    abstract Iterator handleAttributesSubtree(Element var1, NameSpaceSymbTable var2) throws CanonicalizationException;

    public final boolean is_includeComments() {
        return this._includeComments;
    }

    public final void set_includeComments(boolean bl) {
        this._includeComments = bl;
    }

    public void setWriter(OutputStream outputStream) {
        this._writer = outputStream;
    }

    static {
        try {
            nullNode = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", XMLNS);
            nullNode.setValue("");
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to create nullNode" + exception);
        }
    }
}

