/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.x509.XMLX509SubjectName;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class X509SubjectNameResolver
extends KeyResolverSpi {
    static Log log = LogFactory.getLog((class$org$apache$xml$security$keys$keyresolver$implementations$X509SubjectNameResolver == null ? (class$org$apache$xml$security$keys$keyresolver$implementations$X509SubjectNameResolver = X509SubjectNameResolver.class$("org.apache.xml.security.keys.keyresolver.implementations.X509SubjectNameResolver")) : class$org$apache$xml$security$keys$keyresolver$implementations$X509SubjectNameResolver).getName());
    private Element[] _x509childNodes = null;
    private XMLX509SubjectName[] _x509childObject = null;
    static /* synthetic */ Class class$org$apache$xml$security$keys$keyresolver$implementations$X509SubjectNameResolver;

    public boolean engineCanResolve(Element element, String string, StorageResolver storageResolver) {
        if (log.isDebugEnabled()) {
            log.debug("Can I resolve " + element.getTagName() + "?");
        }
        if (!XMLUtils.elementIsInSignatureSpace(element, "X509Data")) {
            log.debug("I can't");
            return false;
        }
        this._x509childNodes = XMLUtils.selectDsNodes(element, "X509SubjectName");
        if (this._x509childNodes != null && this._x509childNodes.length > 0) {
            log.debug("Yes Sir, I can");
            return true;
        }
        log.debug("I can't");
        return false;
    }

    public PublicKey engineResolvePublicKey(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        X509Certificate x509Certificate = this.engineResolveX509Certificate(element, string, storageResolver);
        if (x509Certificate != null) {
            return x509Certificate.getPublicKey();
        }
        return null;
    }

    public X509Certificate engineResolveX509Certificate(Element element, String string, StorageResolver storageResolver) throws KeyResolverException {
        try {
            int n;
            if (this._x509childNodes == null && ((n = this.engineCanResolve(element, string, storageResolver)) == 0 || this._x509childNodes == null)) {
                return null;
            }
            if (storageResolver == null) {
                Object[] objectArray = new Object[]{"X509SubjectName"};
                KeyResolverException keyResolverException = new KeyResolverException("KeyResolver.needStorageResolver", objectArray);
                log.info("", keyResolverException);
                throw keyResolverException;
            }
            this._x509childObject = new XMLX509SubjectName[this._x509childNodes.length];
            for (n = 0; n < this._x509childNodes.length; ++n) {
                this._x509childObject[n] = new XMLX509SubjectName(this._x509childNodes[n], string);
            }
            while (storageResolver.hasNext()) {
                X509Certificate x509Certificate = storageResolver.next();
                XMLX509SubjectName xMLX509SubjectName = new XMLX509SubjectName(element.getOwnerDocument(), x509Certificate);
                log.debug("Found Certificate SN: " + xMLX509SubjectName.getSubjectName());
                for (int i = 0; i < this._x509childObject.length; ++i) {
                    log.debug("Found Element SN:     " + this._x509childObject[i].getSubjectName());
                    if (xMLX509SubjectName.equals(this._x509childObject[i])) {
                        log.debug("match !!! ");
                        return x509Certificate;
                    }
                    log.debug("no match...");
                }
            }
            return null;
        }
        catch (XMLSecurityException xMLSecurityException) {
            log.debug("XMLSecurityException", xMLSecurityException);
            throw new KeyResolverException("generic.EmptyMessage", xMLSecurityException);
        }
    }

    public SecretKey engineResolveSecretKey(Element element, String string, StorageResolver storageResolver) {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

