/*
 * Decompiled with CFR 0.152.
 */
package org.globus.axis.description;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.OperationType;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.description.FaultDesc;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ParameterDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.enum.Scope;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.message.addressing.handler.AddressingHandler;
import org.apache.axis.message.addressing.util.AddressingUtils;
import org.apache.axis.utils.cache.ClassCache;
import org.apache.axis.utils.cache.JavaClass;
import org.apache.axis.wsdl.symbolTable.BindingEntry;
import org.apache.axis.wsdl.symbolTable.Element;
import org.apache.axis.wsdl.symbolTable.Parameter;
import org.apache.axis.wsdl.symbolTable.Parameters;
import org.apache.axis.wsdl.symbolTable.SymbolTable;
import org.apache.axis.wsdl.symbolTable.TypeEntry;
import org.apache.axis.wsdl.toJava.JavaGeneratorFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.description.Resources;
import org.globus.axis.providers.RPCProvider;
import org.globus.util.I18n;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.container.ServiceManager;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ServiceDescUtil {
    public static final String PROVIDER_MAPPING = "providerMapping";
    public static final String PROVIDERS_OPTION = "providers";
    private static final String INITIALIZED = "org.globus.wsrf.axis.servicedesc.initialized";
    public static final String ALLOWED_METHODS_CLASS = "allowedMethodsClass";
    public static final String ACTION_MAP = "addressing.action.map";
    static Log logger = LogFactory.getLog(ServiceDescUtil.class.getName());
    private static I18n i18n = I18n.getI18n(Resources.class.getName());

    public static void resetOperations(MessageContext msgContext) throws AxisFault {
        try {
            ServiceManager.initializeService(msgContext);
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
        AddressingHandler.resetContextOperations(msgContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeService(MessageContext msgContext) throws Exception {
        ServiceDesc serviceDesc;
        SOAPService service = msgContext.getService();
        if (service == null) {
            return;
        }
        ServiceDesc serviceDesc2 = serviceDesc = service.getInitializedServiceDesc(msgContext);
        synchronized (serviceDesc2) {
            if (serviceDesc.getProperty(INITIALIZED) != null) {
                return;
            }
            boolean reserialize = false;
            if (ServiceDescUtil.initializeProviders(msgContext, service, serviceDesc)) {
                reserialize = true;
            }
            ServiceDescUtil.updateAllowedMethods(msgContext, service, serviceDesc);
            if (ServiceDescUtil.fixNamespaces(msgContext, service, serviceDesc)) {
                reserialize = true;
            }
            serviceDesc.setProperty(INITIALIZED, Boolean.TRUE);
        }
    }

    public static boolean initializeProviders(MessageContext msgCtx, SOAPService service, ServiceDesc serviceDesc) throws Exception {
        boolean operDescModified = false;
        boolean rightHandler = service.getPivotHandler() instanceof RPCProvider;
        String providers = (String)service.getOption(PROVIDERS_OPTION);
        if (providers == null) {
            if (!rightHandler) {
                return operDescModified;
            }
        } else if (!rightHandler) {
            throw new Exception(i18n.getMessage("invalidPivotHandler", new Object[]{service.getName(), RPCProvider.class.getName()}));
        }
        String scopeOpt = (String)service.getOption("scope");
        Scope scope = Scope.getScope(scopeOpt, Scope.DEFAULT);
        if (scope != Scope.APPLICATION && scope != Scope.REQUEST) {
            throw new Exception(i18n.getMessage("invalidScope", new Object[]{service.getName(), "Application", "Request"}));
        }
        AxisEngine engine = msgCtx.getAxisEngine();
        if (scope == Scope.APPLICATION) {
            Class serviceClass = ((JavaServiceDesc)serviceDesc).getImplClass();
            Object serviceInstance = RPCProvider.getNewServiceInstance(msgCtx, serviceClass);
            engine.getApplicationSession().set(serviceDesc.getName(), serviceInstance);
        }
        if (providers == null) {
            return operDescModified;
        }
        WSDDGlobalConfiguration globalConfig = null;
        EngineConfiguration config = engine.getConfig();
        if (config instanceof WSDDEngineConfiguration) {
            WSDDDeployment deployment = ((WSDDEngineConfiguration)config).getDeployment();
            globalConfig = deployment.getGlobalConfiguration();
        }
        ClassCache cache = engine.getClassCache();
        ClassLoader cl = msgCtx.getClassLoader();
        HashMap<OperationDesc, Class> mapping = null;
        StringTokenizer tokens = new StringTokenizer(providers);
        while (tokens.hasMoreTokens()) {
            String tmp;
            String provider = tokens.nextToken();
            if (globalConfig != null && (tmp = globalConfig.getParameter(provider)) != null) {
                provider = tmp.trim();
            }
            JavaClass jc = cache.lookup(provider, cl);
            Class providerClass = jc.getJavaClass();
            JavaServiceDesc providerDesc = new JavaServiceDesc();
            providerDesc.loadServiceDescByIntrospection(providerClass);
            ArrayList operations = providerDesc.getOperations();
            Iterator iter = operations.iterator();
            String operationName = null;
            Object providerObj = null;
            while (iter.hasNext()) {
                OperationDesc operation = (OperationDesc)iter.next();
                operationName = operation.getName();
                if (serviceDesc.getOperationsByName(operationName) != null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Added operation '" + operationName + "' for " + serviceDesc.getName() + " service");
                }
                serviceDesc.addOperationDesc(operation);
                if (mapping == null) {
                    mapping = new HashMap<OperationDesc, Class>();
                    service.setOption(PROVIDER_MAPPING, mapping);
                }
                if (providerObj == null) {
                    if (scope == Scope.APPLICATION) {
                        providerObj = RPCProvider.getNewServiceInstance(msgCtx, providerClass);
                        String key = serviceDesc.getName() + "/" + providerObj.hashCode();
                        engine.getApplicationSession().set(key, providerObj);
                    } else {
                        providerObj = providerClass;
                    }
                }
                mapping.put(operation, (Class)providerObj);
            }
        }
        operDescModified = mapping != null;
        return operDescModified;
    }

    public static boolean fixNamespaces(MessageContext msgCtx, SOAPService service, ServiceDesc serviceDesc) throws Exception {
        boolean operDescModified = false;
        if (serviceDesc.getWSDLFile() == null) {
            return operDescModified;
        }
        if (serviceDesc.getStyle() != Style.DOCUMENT || serviceDesc.getUse() != Use.LITERAL) {
            if (logger.isDebugEnabled()) {
                logger.debug("Not a doc/lit service: " + serviceDesc.getName());
            }
            return operDescModified;
        }
        service.generateWSDL(msgCtx);
        Document wsdlDoc = (Document)msgCtx.getProperty("WSDL");
        if (wsdlDoc == null) {
            return operDescModified;
        }
        msgCtx.removeProperty("WSDL");
        AxisEngine engine = msgCtx.getAxisEngine();
        ClassCache cache = engine.getClassCache();
        ClassLoader cl = msgCtx.getClassLoader();
        if (logger.isDebugEnabled()) {
            logger.debug("Fixing namespaces for: " + serviceDesc.getName());
        }
        SymbolTable table = new SymbolTable(new JavaGeneratorFactory().getBaseTypeMapping(), true, logger.isDebugEnabled(), !serviceDesc.isWrapped());
        table.setQuiet(!logger.isDebugEnabled());
        File wsdlFile = new File(serviceDesc.getWSDLFile());
        if (!wsdlFile.exists()) {
            String homeDir = (String)msgCtx.getProperty("home.dir");
            if (homeDir == null) {
                homeDir = ".";
            }
            wsdlFile = new File(homeDir, serviceDesc.getWSDLFile());
        }
        table.populate(wsdlFile.getAbsolutePath(), wsdlDoc);
        HashMap symbolMap = table.getHashMap();
        Iterator symbols = symbolMap.values().iterator();
        boolean hasBinding = false;
        while (symbols.hasNext()) {
            Vector symbolVector = (Vector)symbols.next();
            for (int i = 0; i < symbolVector.size(); ++i) {
                if (!(symbolVector.get(i) instanceof BindingEntry)) continue;
                hasBinding = true;
                BindingEntry bindingEntry = (BindingEntry)symbolVector.get(i);
                Binding binding = bindingEntry.getBinding();
                PortType portType = binding.getPortType();
                Iterator operations = portType.getOperations().iterator();
                while (operations.hasNext()) {
                    Operation operation = (Operation)operations.next();
                    String opName = operation.getName();
                    OperationDesc operationDesc = serviceDesc.getOperationByName(opName);
                    if (operationDesc == null && Character.isUpperCase(opName.charAt(0))) {
                        opName = Character.toLowerCase(opName.charAt(0)) + opName.substring(1);
                        logger.debug("Trying: " + opName);
                        operationDesc = serviceDesc.getOperationByName(opName);
                    }
                    if (operationDesc == null) {
                        throw new Exception(i18n.getMessage("missingOperation", new Object[]{operation.getName(), serviceDesc.getName()}));
                    }
                    ServiceDescUtil.createWSAActionMapping(serviceDesc, operationDesc, portType.getQName(), operation);
                    Parameters params = bindingEntry.getParameters(operation);
                    if (params.list.size() > 1) {
                        throw new Exception(i18n.getMessage("invalidNumberOfParams"));
                    }
                    for (int j = 0; j < params.list.size(); ++j) {
                        ParameterDesc paramDesc;
                        Parameter param = (Parameter)params.list.get(j);
                        if (param.getMode() != 1 || (paramDesc = operationDesc.getParameter(j)) == null) continue;
                        paramDesc.setQName(param.getQName());
                        operDescModified = true;
                    }
                    ServiceDescUtil.fixFaults(serviceDesc, operationDesc, cache, cl, operation, table);
                    if (params.returnParam != null) {
                        operationDesc.setReturnQName(params.returnParam.getQName());
                    }
                    QName operationName = new QName(portType.getQName().getNamespaceURI(), opName);
                    operationDesc.setElementQName(operationName);
                    if (operation.getStyle() != OperationType.ONE_WAY) continue;
                    operationDesc.setMep(OperationType.ONE_WAY);
                }
            }
        }
        if (!hasBinding) {
            throw new WSDLException("OTHER_ERROR", i18n.getMessage("noWSDLBinding", new Object[]{serviceDesc.getName()}));
        }
        return operDescModified;
    }

    private static void createWSAActionMapping(ServiceDesc serviceDesc, OperationDesc operationDesc, QName portTypeQName, Operation operation) throws Exception {
        String action = AddressingUtils.getOutputAction(portTypeQName, operation);
        HashMap<OperationDesc, String> actionMap = (HashMap<OperationDesc, String>)serviceDesc.getProperty(ACTION_MAP);
        if (actionMap == null) {
            actionMap = new HashMap<OperationDesc, String>();
            serviceDesc.setProperty(ACTION_MAP, actionMap);
        }
        actionMap.put(operationDesc, action);
    }

    private static void fixFaults(ServiceDesc serviceDesc, OperationDesc operationDesc, ClassCache cache, ClassLoader cl, Operation operation, SymbolTable table) throws Exception {
        Serializable fault;
        HashMap<Object, Serializable> faultMap = new HashMap<Object, Serializable>();
        ArrayList list = operationDesc.getFaults();
        if (list != null) {
            JavaClass jc = null;
            TypeDesc typeDesc = null;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                fault = (FaultDesc)iter.next();
                QName xmlType = ((FaultDesc)fault).getXmlType();
                if (xmlType == null) {
                    jc = cache.lookup(((FaultDesc)fault).getClassName(), cl);
                    typeDesc = TypeDesc.getTypeDescForClass(jc.getJavaClass());
                    if (typeDesc != null) {
                        xmlType = typeDesc.getXmlType();
                        if (xmlType == null) {
                            logger.warn(i18n.getMessage("typeDescNoXmlType", jc.getJavaClass()));
                            continue;
                        }
                    } else {
                        faultMap.put(((FaultDesc)fault).getName(), fault);
                        logger.debug(i18n.getMessage("noFaultTypeDesc", jc.getJavaClass()));
                        continue;
                    }
                }
                faultMap.put(xmlType, fault);
            }
        }
        Map faults = operation.getFaults();
        Iterator iter = faults.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            fault = (Fault)entry.getValue();
            Message message = fault.getMessage();
            if (message == null) {
                logger.warn(i18n.getMessage("noFaultMessage", new Object[]{entry.getKey(), serviceDesc.getName()}));
                continue;
            }
            Map parts = message.getParts();
            if (parts == null || parts.size() != 1) {
                logger.warn(i18n.getMessage("invalidFaultPart", new Object[]{entry.getKey(), serviceDesc.getName()}));
                continue;
            }
            Part part = (Part)parts.values().iterator().next();
            QName elementQName = part.getElementName();
            if (elementQName == null) {
                logger.warn(i18n.getMessage("missingElementAttribute", new Object[]{entry.getKey(), serviceDesc.getName()}));
                continue;
            }
            Element elementTypeEntry = table.getElement(elementQName);
            if (elementTypeEntry == null) {
                logger.warn(i18n.getMessage("missingElementFault", new Object[]{entry.getKey(), serviceDesc.getName()}));
                continue;
            }
            TypeEntry typeEntry = elementTypeEntry.getRefType();
            if (typeEntry == null) {
                logger.warn(i18n.getMessage("missingTypeFault", new Object[]{entry.getKey(), serviceDesc.getName()}));
                continue;
            }
            QName typeQName = typeEntry.getQName();
            if (typeQName == null) {
                throw new Exception(i18n.getMessage("noTypeQName"));
            }
            FaultDesc faultDesc = (FaultDesc)faultMap.get(typeQName);
            if (faultDesc == null && (faultDesc = (FaultDesc)faultMap.get(message.getQName().getLocalPart())) == null) {
                logger.warn(i18n.getMessage("missingFault", new Object[]{elementQName, operationDesc.getName(), serviceDesc.getName()}));
                continue;
            }
            logger.debug("Updated fault qname '" + elementQName + "' for operation '" + operationDesc.getName() + "'");
            faultDesc.setQName(elementQName);
        }
    }

    public static void updateWSDL(MessageContext ctx) throws Exception {
        ServiceDescUtil.updateWSDLSOAPAddress(ctx);
        ServiceDescUtil.updateWSDLImport(ctx);
    }

    public static void updateWSDLImport(MessageContext ctx) throws Exception {
        Document doc = (Document)ctx.getProperty("WSDL");
        if (doc == null) {
            return;
        }
        SOAPService service = ctx.getService();
        if (service == null) {
            return;
        }
        ServiceDesc serviceDesc = service.getInitializedServiceDesc(ctx);
        NodeList nodes = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/", "import");
        int len = nodes.getLength();
        if (len > 0) {
            String wsdlURL = ContainerConfig.getExternalWebRoot(ctx) + serviceDesc.getWSDLFile();
            wsdlURL = wsdlURL.substring(0, wsdlURL.lastIndexOf(47));
            for (int i = 0; i < nodes.getLength(); ++i) {
                org.w3c.dom.Element importElement = (org.w3c.dom.Element)nodes.item(i);
                String location = importElement.getAttribute("location");
                if (location == null) {
                    throw new WSDLException("OTHER_ERROR", i18n.getMessage("noWSDLImportLocationError"));
                }
                if (location.indexOf("://") != -1) continue;
                String wsdlDir = wsdlURL;
                int subPath = location.indexOf("../");
                while (subPath != -1) {
                    location = location.substring(subPath + 3);
                    wsdlDir = wsdlDir.substring(0, wsdlDir.lastIndexOf(47));
                    subPath = location.indexOf("../");
                }
                importElement.setAttribute("location", wsdlDir + "/" + location);
            }
        }
    }

    public static void updateWSDLSOAPAddress(MessageContext ctx) throws Exception {
        Document doc = (Document)ctx.getProperty("WSDL");
        if (doc == null) {
            return;
        }
        NodeList nodes = doc.getElementsByTagNameNS("http://schemas.xmlsoap.org/wsdl/soap/", "address");
        if (nodes.getLength() == 0) {
            throw new WSDLException("OTHER_ERROR", i18n.getMessage("noSOAPAddressError"));
        }
        AxisEngine engine = ctx.getAxisEngine();
        ContainerConfig config = ContainerConfig.getConfig(engine);
        String servicePath = ctx.getTargetService();
        for (int i = 0; i < nodes.getLength(); ++i) {
            org.w3c.dom.Element address = (org.w3c.dom.Element)nodes.item(i);
            URL url = new URL(ServiceHost.getProtocol(ctx), ServiceHost.getHost(ctx), ServiceHost.getPort(ctx), "/" + config.getWSRFLocation() + servicePath);
            address.setAttribute("location", url.toExternalForm());
        }
    }

    public static void updateAllowedMethods(MessageContext msgCtx, SOAPService service, ServiceDesc serviceDesc) throws Exception {
        List allowedOperations = null;
        if (serviceDesc.getAllowedMethods() != null) {
            allowedOperations = serviceDesc.getAllowedMethods();
        } else {
            if (service.getOption("allowedMethods") != null) {
                return;
            }
            allowedOperations = ServiceDescUtil.getAllowedOperations(msgCtx, service, serviceDesc);
            if (allowedOperations == null) {
                return;
            }
        }
        ArrayList<OperationDesc> removedOperations = new ArrayList<OperationDesc>();
        ArrayList operations = serviceDesc.getOperations();
        Iterator iter = operations.iterator();
        while (iter.hasNext()) {
            OperationDesc operation = (OperationDesc)iter.next();
            if (!allowedOperations.contains(operation.getName())) {
                removedOperations.add(operation);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("operation '" + operation.getName() + "' disallowed for service '" + service.getName() + "'");
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("operation '" + operation.getName() + "' allowed for service '" + service.getName() + "'");
        }
        iter = removedOperations.iterator();
        while (iter.hasNext()) {
            serviceDesc.removeOperationDesc((OperationDesc)iter.next());
        }
    }

    protected static List getAllowedOperations(MessageContext msgCtx, SOAPService service, ServiceDesc serviceDesc) throws Exception {
        String allowedClass = (String)service.getOption(ALLOWED_METHODS_CLASS);
        if (allowedClass == null) {
            return null;
        }
        AxisEngine engine = msgCtx.getAxisEngine();
        ClassCache cache = engine.getClassCache();
        ClassLoader cl = msgCtx.getClassLoader();
        JavaClass jc = cache.lookup(allowedClass, cl);
        ArrayList<String> allowedOperations = new ArrayList<String>();
        Method[] methods = ServiceDescUtil.getMethods(jc.getJavaClass());
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isPublic(methods[i].getModifiers())) continue;
            allowedOperations.add(methods[i].getName());
        }
        return allowedOperations;
    }

    protected static Method[] getMethods(Class clazz) {
        if (clazz.isInterface()) {
            return clazz.getMethods();
        }
        return clazz.getDeclaredMethods();
    }
}

