/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.proxy;

import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.X509ExtensionSet;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.bc.BouncyCastleOpenSSLKey;
import org.globus.tools.proxy.GridProxyModel;

public class DefaultGridProxyModel
extends GridProxyModel {
    public GlobusCredential createProxy(String pwd) throws Exception {
        this.getProperties();
        this.userCert = CertUtil.loadCertificate(this.props.getUserCertFile());
        BouncyCastleOpenSSLKey key = new BouncyCastleOpenSSLKey(this.props.getUserKeyFile());
        if (key.isEncrypted()) {
            try {
                key.decrypt(pwd);
            }
            catch (GeneralSecurityException e) {
                throw new Exception("Wrong password or other security error");
            }
        }
        PrivateKey userKey = key.getPrivateKey();
        BouncyCastleCertProcessingFactory factory = BouncyCastleCertProcessingFactory.getDefault();
        int proxyType = this.getLimited() ? 2 : 3;
        return factory.createCredential(new X509Certificate[]{this.userCert}, userKey, this.props.getProxyStrength(), this.props.getProxyLifeTime() * 3600, proxyType, (X509ExtensionSet)null);
    }
}

