/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.proxy;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.globus.util.ConfigUtil;

public class GridProxyProperties {
    private static final String PROPS_FILE = "cog.properties";
    private static final String gridPropsFile = ConfigUtil.globus_dir + "cog.properties";
    private int hours = 24;
    private int bits = 512;
    private boolean limited = false;
    private String userCertFile = ConfigUtil.discoverUserCertLocation();
    private String userKeyFile = ConfigUtil.discoverUserKeyLocation();
    private String CACertFile = ConfigUtil.discoverCertDirLocation();
    private String proxyFile = ConfigUtil.discoverProxyLocation();
    private int credLifetime = 168;
    private int portalLifetime = 2;
    private String myproxyServer = "localhost";
    private int myproxyPort = 7512;
    private Properties properties = null;

    public GridProxyProperties() {
        if (this.hasProperties()) {
            this.loadProperties();
        }
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public int getHours() {
        return this.hours;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public int getBits() {
        return this.bits;
    }

    public void setLimited(boolean limited) {
        this.limited = limited;
    }

    public boolean getLimited() {
        return this.limited;
    }

    public void setProxyFile(String proxyFile) {
        this.proxyFile = proxyFile;
    }

    public String getProxyFile() {
        return this.proxyFile;
    }

    public void setUserCertFile(String userCertFile) {
        this.userCertFile = userCertFile;
    }

    public String getUserCertFile() {
        return this.userCertFile;
    }

    public void setUserKeyFile(String userKeyFile) {
        this.userKeyFile = userKeyFile;
    }

    public String getUserKeyFile() {
        return this.userKeyFile;
    }

    public void setCACertFile(String CACertFile) {
        this.CACertFile = CACertFile;
    }

    public String getCACertFile() {
        return this.CACertFile;
    }

    public void setPortalLifetime(int portalLifetime) {
        this.portalLifetime = portalLifetime;
    }

    public int getPortalLifetime() {
        return this.portalLifetime;
    }

    public void setCredLifetime(int credLifetime) {
        this.credLifetime = credLifetime;
    }

    public int getCredLifetime() {
        return this.credLifetime;
    }

    public void setMyproxyServer(String myproxyServer) {
        this.myproxyServer = myproxyServer;
    }

    public String getMyproxyServer() {
        return this.myproxyServer;
    }

    public void setMyproxyPort(int myproxyPort) {
        this.myproxyPort = myproxyPort;
    }

    public int getMyproxyPort() {
        return this.myproxyPort;
    }

    public boolean hasProperties() {
        File pfile = new File(gridPropsFile);
        return pfile.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void loadProperties() {
        block14: {
            props = new Properties();
            in = null;
            try {
                in = new FileInputStream(GridProxyProperties.gridPropsFile);
                props.load(in);
                var5_3 = null;
                ** if (in == null) goto lbl-1000
            }
            catch (Throwable var4_13) {
                var5_6 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw var4_13;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (FileNotFoundException fnfe) {
                    System.err.println("loadGridProxyProperties: FileNotFoundException");
                    var5_4 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                    break block14;
                }
                catch (IOException ioe) {
                    System.err.println("loadGridProxyProperties: IOException error");
                    var5_5 = null;
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        this.properties = props;
        this.hours = GridProxyProperties.getIntValue(props, "proxy.lifetime", 24);
        this.bits = GridProxyProperties.getIntValue(props, "proxy.strength", 512);
        this.limited = Boolean.valueOf(props.getProperty("limited"));
        this.userCertFile = GridProxyProperties.getStrValue(props, "usercert", ConfigUtil.discoverUserCertLocation());
        this.userKeyFile = GridProxyProperties.getStrValue(props, "userkey", ConfigUtil.discoverUserKeyLocation());
        this.proxyFile = GridProxyProperties.getStrValue(props, "proxy", ConfigUtil.discoverProxyLocation());
        this.CACertFile = GridProxyProperties.getStrValue(props, "cacert", ConfigUtil.discoverCertDirLocation());
        this.credLifetime = GridProxyProperties.getIntValue(props, "cred_lifetime", 168);
        this.portalLifetime = GridProxyProperties.getIntValue(props, "portal_lifetime", 2);
        this.myproxyServer = GridProxyProperties.getStrValue(props, "myproxy_server", "localhost");
        this.myproxyPort = GridProxyProperties.getIntValue(props, "myproxy_port", 7512);
    }

    private static String getStrValue(Properties props, String prop, String defaultValue) {
        String value = props.getProperty(prop);
        if (value != null && value.trim().length() > 0) {
            return value.trim();
        }
        return defaultValue;
    }

    private static int getIntValue(Properties props, String prop, int defaultValue) {
        String value = props.getProperty(prop);
        if (value != null && value.trim().length() > 0) {
            return Integer.parseInt(value.trim());
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean saveProperties() {
        Properties props = this.properties == null ? new Properties() : this.properties;
        props.setProperty("proxy.lifetime", String.valueOf(this.hours));
        props.setProperty("proxy.strength", String.valueOf(this.bits));
        props.setProperty("limited", String.valueOf(this.limited));
        props.setProperty("usercert", this.userCertFile);
        props.setProperty("userkey", this.userKeyFile);
        props.setProperty("proxy", this.proxyFile);
        props.setProperty("cacert", this.CACertFile);
        props.setProperty("cred_lifetime", String.valueOf(this.credLifetime));
        props.setProperty("portal_lifetime", String.valueOf(this.portalLifetime));
        props.setProperty("myproxy_server", this.myproxyServer);
        props.setProperty("myproxy_port", String.valueOf(this.myproxyPort));
        FileOutputStream out = null;
        out = new FileOutputStream(gridPropsFile);
        props.store(out, "GridProxyInit properties");
        Object var6_3 = null;
        if (out == null) return true;
        try {
            out.close();
            return true;
        }
        catch (IOException e) {}
        return true;
        {
            catch (FileNotFoundException fnfe) {
                System.err.println("saveGridProxyProperties: FileNotFoundException");
                boolean bl = false;
                Object var6_4 = null;
                if (out == null) return bl;
                try {
                    out.close();
                    return bl;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return bl;
            }
            catch (IOException ioe) {
                boolean bl;
                try {
                    System.err.println("saveGridProxyProperties: IOException");
                    bl = false;
                    Object var6_5 = null;
                    if (out == null) return bl;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (out == null) throw throwable;
                    try {
                        out.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    out.close();
                    return bl;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return bl;
            }
        }
    }
}

