/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.client;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.globus.wsrf.client.BaseClient;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;
import org.oasis.wsn.GetCurrentMessageResponse;
import org.oasis.wsn.NotificationProducer;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;

public class GetCurrentMessage
extends BaseClient {
    public static void main(String[] args) {
        GetCurrentMessage client = new GetCurrentMessage();
        client.setCustomUsage("topic");
        QName topicQName = null;
        try {
            CommandLine line = client.parse(args);
            List options = line.getArgList();
            if (options == null || options.isEmpty()) {
                throw new ParseException("topic name expected");
            }
            topicQName = QName.valueOf((String)options.get(0));
        }
        catch (ParseException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        WSBaseNotificationServiceAddressingLocator locator = new WSBaseNotificationServiceAddressingLocator();
        try {
            NotificationProducer port = locator.getNotificationProducerPort(client.getEPR());
            client.setOptions((Stub)((Object)port));
            TopicExpressionType topicExpression = new TopicExpressionType();
            topicExpression.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
            topicExpression.setValue(topicQName);
            org.oasis.wsn.GetCurrentMessage request = new org.oasis.wsn.GetCurrentMessage();
            request.setTopic(topicExpression);
            GetCurrentMessageResponse response = port.getCurrentMessage(request);
            System.out.println(AnyHelper.toSingleString(response));
        }
        catch (Exception e) {
            if (client.isDebugMode()) {
                FaultHelper.printStackTrace(e);
            } else {
                System.err.println("Error: " + FaultHelper.getMessage(e));
            }
            System.exit(2);
        }
    }
}

