/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfigurationFactory;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.EngineConfigurationFactoryFinder;
import org.apache.axis.server.AxisServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.util.Util;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.container.BaseContainerConfig;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.container.ServiceManager;
import org.globus.wsrf.container.UsageConfig;

public class AxisServlet
extends org.apache.axis.transport.http.AxisServlet {
    private static Log logger = LogFactory.getLog(AxisServlet.class.getName());

    public void init() throws ServletException {
        String serverID;
        super.init();
        AxisServer server = null;
        try {
            server = this.getEngine();
        }
        catch (AxisFault e) {
            throw new ServletException(e);
        }
        ContainerConfig config = ContainerConfig.getConfig(server);
        ServletConfig servletConfig = this.getServletConfig();
        ServletContext context = servletConfig.getServletContext();
        File rootFile = new File(context.getRealPath("/"));
        String rootContext = rootFile.getName();
        config.setOption("webContext", rootContext);
        String webInfPath = this.getWebInfPath();
        String homeDir = this.getHomeDir();
        BaseContainerConfig.setEngine(server);
        BaseContainerConfig.setBaseDirectory(webInfPath);
        BaseContainerConfig.setSchemaDirectory(homeDir);
        MessageContext msgContext = new MessageContext(server);
        msgContext.setProperty("configPath", webInfPath);
        msgContext.setProperty("home.dir", homeDir);
        String configProfile = servletConfig.getInitParameter("config.profile");
        if (configProfile != null) {
            msgContext.setProperty("config.profile", configProfile);
        }
        UsageConfig.setContainerType((short)2);
        String host = null;
        try {
            host = ServiceHost.getHost(config);
        }
        catch (IOException e) {
            throw new ServletException(e);
        }
        String protocol = servletConfig.getInitParameter("defaultProtocol");
        String port = servletConfig.getInitParameter("defaultPort");
        if (protocol != null && port != null) {
            ServiceHost.setDefaults(protocol, host, Integer.parseInt(port));
        }
        if ((serverID = System.getProperty("org.globus.wsrf.container.server.id")) == null && (serverID = config.getOption("server.id")) == null) {
            serverID = host + "-" + rootContext;
        }
        BaseContainerConfig.setContainerID(serverID);
        try {
            ServiceManager.getServiceManager(server).start(msgContext);
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        AxisServer server = null;
        try {
            server = this.getEngine();
        }
        catch (AxisFault e) {
            logger.warn("", e);
            return;
        }
        ServiceManager.getServiceManager(server).stop();
        super.destroy();
    }

    static {
        Class c = EngineConfigurationFactoryFinder.class;
        AxisProperties.setClassDefaults(EngineConfigurationFactory.class, new String[]{"org.globus.axis.configuration.EngineConfigurationFactoryServlet", "org.apache.axis.configuration.EngineConfigurationFactoryServlet", "org.apache.axis.configuration.EngineConfigurationFactoryDefault"});
        Util.registerTransport();
    }
}

