/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.io.OutputStream;
import java.security.cert.X509Certificate;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.gsi.jaas.GlobusPrincipal;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.util.I18n;
import org.globus.wsrf.container.ServiceDispatcher;
import org.globus.wsrf.container.ServiceRequest;
import org.globus.wsrf.container.ServiceThread;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.utils.Resources;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

class GSIServiceThread
extends ServiceThread {
    private static Log logger = LogFactory.getLog(GSIServiceThread.class.getName());
    private static I18n i18n = I18n.getI18n(Resources.class.getName());

    public GSIServiceThread(ServiceDispatcher dispatcher) {
        super(dispatcher);
    }

    protected String getProtocol() {
        return "https";
    }

    protected void process(ServiceRequest request) {
        logger.debug(this.getName() + ": processing requests");
        GSSManager manager = ExtendedGSSManager.getInstance();
        GssSocket gsiSocket = null;
        OutputStream out = null;
        try {
            ExtendedGSSContext extGss;
            X509Certificate[] certs;
            ContainerSecurityConfig config = ContainerSecurityConfig.getConfig();
            config.refresh();
            Subject containerSub = config.getSubject();
            if (containerSub == null) {
                throw new RuntimeException(i18n.getMessage("noValidCreds"));
            }
            GSSCredential credentials = JaasGssUtil.getCredential(containerSub);
            ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(credentials);
            context.setOption(GSSConstants.GSS_MODE, GSIConstants.MODE_SSL);
            context.setOption(GSSConstants.ACCEPT_NO_CLIENT_CERTS, Boolean.TRUE);
            GssSocketFactory factory = GssSocketFactory.getDefault();
            gsiSocket = (GssSocket)factory.createSocket(request.getSocket(), null, 0, context);
            gsiSocket.setUseClientMode(false);
            gsiSocket.setAuthorization(null);
            out = gsiSocket.getOutputStream();
            String globusID = ((Object)context.getSrcName()).toString();
            logger.debug(this.getName() + ": Authenticated globus user: " + globusID);
            Subject subject = this.getSubject();
            subject.getPrincipals().add(new GlobusPrincipal(globusID));
            if (context instanceof ExtendedGSSContext && (certs = (X509Certificate[])(extGss = context).inquireByOid(GSSConstants.X509_CERT_CHAIN)) != null) {
                subject.getPublicCredentials().add(certs);
            }
            this.msgContext.setProperty("org.globus.security.transport.context", context);
            if (context.getConfState()) {
                this.msgContext.setProperty("org.globus.security.transport.type", Constants.ENCRYPTION);
            } else if (context.getIntegState()) {
                this.msgContext.setProperty("org.globus.security.transport.type", Constants.SIGNATURE);
            } else {
                this.msgContext.setProperty("org.globus.security.transport.type", Constants.NONE);
            }
        }
        catch (Exception e) {
            if (gsiSocket == null) {
                try {
                    request.getSocket().close();
                }
                catch (Exception ee) {}
            } else {
                try {
                    gsiSocket.close();
                }
                catch (Exception ee) {
                    // empty catch block
                }
            }
            logger.error(i18n.getMessage("serverFault00"), e);
            return;
        }
        ServiceRequest req = new ServiceRequest(gsiSocket, request.getServerSocket());
        super.process(req);
    }

    protected Subject getSubject() {
        Subject subject = (Subject)this.msgContext.getProperty("callerSubject");
        if (subject == null) {
            subject = new Subject();
            this.msgContext.setProperty("callerSubject", subject);
        }
        return subject;
    }
}

