/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.ws.security.message.WSSAddUsernameToken;
import org.globus.wsrf.impl.security.util.EnvelopeConverter;
import org.w3c.dom.Document;

public class UsernameSOAPEnvelopeBuilder
extends WSSAddUsernameToken {
    protected String userName;
    protected MessageContext msgContext;

    public UsernameSOAPEnvelopeBuilder(MessageContext msgContext, String _userName) {
        this.userName = _userName;
        this.msgContext = msgContext;
    }

    public SOAPEnvelope build(SOAPEnvelope envelope) throws Exception {
        return this.buildMessage(envelope).getSOAPPart().getEnvelope();
    }

    public SOAPMessage buildMessage(SOAPEnvelope env) throws Exception {
        Document doc = EnvelopeConverter.getInstance().toDocument(env);
        this.setMustUnderstand(false);
        String password = (String)this.msgContext.getProperty("org.globus.security.password");
        if (password != null) {
            String pwType = (String)this.msgContext.getProperty("org.globus.security.password.type");
            if (pwType == null) {
                pwType = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordText";
            }
            this.setPasswordType(pwType);
        }
        this.build(doc, this.userName, password);
        this.addCreated(doc);
        return EnvelopeConverter.getInstance().toSOAPMessage(doc);
    }
}

