/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.wssec;

import javax.crypto.SecretKey;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.apache.axis.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityCallbackHandler;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityException;
import org.globus.wsrf.providers.GSSPrivateKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GSSSecurityEngine
extends WSSecurityEngine {
    private static GSSSecurityEngine engine = new GSSSecurityEngine();
    private static Log log = LogFactory.getLog(GSSSecurityEngine.class.getName());

    public static WSSecurityEngine getInstance() {
        return engine;
    }

    protected SecretKey getSharedKey(Element keyInfoElem, String algorithm, CallbackHandler cb) throws org.apache.ws.security.WSSecurityException {
        KeyInfo keyInfo = null;
        MessageContext msgContext = ((WSSecurityCallbackHandler)cb).getContext();
        try {
            keyInfo = new KeyInfo(keyInfoElem, "http://www.w3.org/2000/09/xmldsig#");
        }
        catch (XMLSecurityException e) {
            throw new org.apache.ws.security.WSSecurityException(3, "unsupportedKeyInfo", null, e);
        }
        SecurityContext context = null;
        try {
            context = GSSSecurityEngine.getContext(msgContext, keyInfo);
        }
        catch (WSSecurityException e) {
            throw new org.apache.ws.security.WSSecurityException(3, "unsupportedKeyInfo", null, e);
        }
        return new GSSPrivateKey((String)context.getID(), context.getContext());
    }

    public static SecurityContext getContext(MessageContext msgContext, KeyInfo keyInfo) throws WSSecurityException {
        SecurityContext securityContext = null;
        securityContext = (SecurityContext)msgContext.getProperty("org.globus.security.secureconv.context");
        if (securityContext == null) {
            if (keyInfo == null) {
                throw new WSSecurityException(4, "nullKeyInfo");
            }
            String contextId = null;
            WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
            Node node = WSSecurityUtil.getDirectChild(keyInfo.getElement(), "SecurityTokenReference", wssConfig.getWsseNS());
            if (node == null) {
                throw new WSSecurityException(4, "unsupportedKeyInfo");
            }
            SecurityTokenReference secRef = null;
            try {
                secRef = new SecurityTokenReference(wssConfig, (Element)node);
            }
            catch (org.apache.ws.security.WSSecurityException e) {
                throw new WSSecurityException(4, "secTokenReferenceErr", null, e);
            }
            if (secRef.containsReference()) {
                Document signatureDocument = keyInfo.getDocument();
                Reference ref = null;
                try {
                    ref = secRef.getReference();
                }
                catch (org.apache.ws.security.WSSecurityException e) {
                    throw new WSSecurityException(4, "noReference", null, e);
                }
                if (ref == null) {
                    throw new WSSecurityException(4, "noReference");
                }
                Element sctElement = WSSecurityUtil.getElementByWsuId(wssConfig, signatureDocument, ref.getURI());
                if (sctElement == null) {
                    throw new WSSecurityException(4, "noContextToken");
                }
                SecurityContextToken secContextToken = null;
                try {
                    secContextToken = new SecurityContextToken(sctElement);
                }
                catch (org.apache.ws.security.WSSecurityException e) {
                    throw new WSSecurityException(4, "invalidContextToken", null, e);
                }
                contextId = secContextToken.getIdentifier();
                if (contextId == null) {
                    throw new WSSecurityException(4, "invalidContextToken");
                }
            } else {
                throw new WSSecurityException(4, "secTokenReferenceErr");
            }
            securityContext = GSSSecurityEngine.getContext(msgContext, contextId);
        }
        return securityContext;
    }

    private static SecurityContext getContext(MessageContext msgContext, String contextId) throws WSSecurityException {
        SecurityContext securityContext = null;
        ContainerConfig config = ContainerConfig.getConfig(msgContext.getAxisEngine());
        String authServicePath = config.getOption("authenticationService");
        log.debug("Authentication service path is " + authServicePath);
        try {
            InitialContext initialContext = new InitialContext();
            ResourceHome home = (ResourceHome)initialContext.lookup("java:comp/env//services/" + authServicePath + "/home");
            log.debug("Context id is " + contextId);
            SimpleResourceKey key = new SimpleResourceKey(home.getKeyTypeName(), contextId);
            securityContext = (SecurityContext)home.find(key);
        }
        catch (NamingException e) {
            throw new WSSecurityException(3, "contextErr", null, e);
        }
        catch (ResourceException e) {
            throw new WSSecurityException(3, "contextErr", null, e);
        }
        msgContext.setProperty("org.globus.security.secureconv.context", securityContext);
        return securityContext;
    }
}

