/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.tools.wsdl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSParticle;
import org.globus.wsrf.tools.wsdl.WSDLPreprocessor;
import org.globus.wsrf.tools.wsdl.WSDLPreprocessorConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TypesProcessor
implements WSDLPreprocessorConstants {
    private Definition definition;
    private Map imports = null;
    private Map includes = null;
    private static Log logger = LogFactory.getLog((class$org$globus$wsrf$tools$wsdl$TypesProcessor == null ? (class$org$globus$wsrf$tools$wsdl$TypesProcessor = TypesProcessor.class$("org.globus.wsrf.tools.wsdl.TypesProcessor")) : class$org$globus$wsrf$tools$wsdl$TypesProcessor).getName());
    static /* synthetic */ Class class$org$globus$wsrf$tools$wsdl$TypesProcessor;

    public TypesProcessor(Definition definition) {
        this.definition = definition;
    }

    private String addPrefix(String namespace, String prefix) {
        String pref = this.definition.getPrefix(namespace);
        if (pref == null) {
            if (this.definition.getNamespace(prefix) == null) {
                this.definition.addNamespace(prefix, namespace);
                pref = prefix;
            } else {
                int i = 0;
                while (this.definition.getNamespace("ns" + i) != null) {
                    ++i;
                }
                pref = "ns" + i;
                this.definition.addNamespace(pref, namespace);
            }
        }
        return pref;
    }

    public void addWSAImport(Map schemaDocumentLocations) throws Exception {
        Element schema = this.getSchema();
        Document doc = schema.getOwnerDocument();
        this.addSchemaDefinitions("http://schemas.xmlsoap.org/ws/2004/03/addressing", schemaDocumentLocations, schema);
        this.addPrefix("http://schemas.xmlsoap.org/ws/2004/03/addressing", "wsa");
    }

    private Element getSchema() throws Exception {
        Types types = this.definition.getTypes();
        if (types == null) {
            types = this.definition.createTypes();
            this.definition.setTypes(types);
        }
        Element schema = null;
        List elementList = types.getExtensibilityElements();
        if (elementList.isEmpty()) {
            UnknownExtensibilityElement extensibilityElement = new UnknownExtensibilityElement();
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            schema = doc.createElementNS("http://www.w3.org/2001/XMLSchema", "xsd:schema");
            Attr nameSpace = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd");
            nameSpace.setValue("http://www.w3.org/2001/XMLSchema");
            schema.setAttributeNode(nameSpace);
            nameSpace = doc.createAttribute("targetNamespace");
            nameSpace.setValue(this.definition.getTargetNamespace());
            schema.setAttributeNode(nameSpace);
            schema.appendChild(doc.createTextNode("\n      "));
            doc.appendChild(schema);
            extensibilityElement.setElement(schema);
            types.addExtensibilityElement(extensibilityElement);
        } else {
            schema = ((UnknownExtensibilityElement)elementList.get(0)).getElement();
        }
        return schema;
    }

    public void addResourceProperties(QName portTypeName, Map resourcePropertyElements, Map schemaDocumentLocations) throws Exception {
        Element sequence;
        NodeList complexTypeElements;
        logger.debug("Starting to build resource properties element");
        PortType portType = this.getPortType(portTypeName);
        QName resourceProperties = (QName)portType.getExtensionAttribute(WSDLPreprocessorConstants.RP);
        this.addPrefix("http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceProperties-1.2-draft-01.xsd", "wsrp");
        Element schema = this.getSchema();
        Document doc = schema.getOwnerDocument();
        String schemaPrefix = "";
        if (schema.getPrefix() != null) {
            schemaPrefix = schema.getPrefix() + ":";
        }
        Element properties = null;
        if (resourceProperties == null) {
            resourceProperties = new QName(portType.getQName().getLocalPart() + "GTWSDLResourceProperties");
            portType.setExtensionAttribute(WSDLPreprocessorConstants.RP, resourceProperties);
            properties = doc.createElementNS("http://www.w3.org/2001/XMLSchema", schemaPrefix + "element");
            properties.setAttribute("name", resourceProperties.getLocalPart());
            properties.appendChild(doc.createTextNode("\n        "));
            schema.appendChild(properties);
            schema.appendChild(doc.createTextNode("\n    "));
        } else {
            NodeList elementNodes = schema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "element");
            for (int i = 0; i < elementNodes.getLength(); ++i) {
                Element element = (Element)elementNodes.item(i);
                String name = element.getAttribute("name");
                if (name == null || !XMLUtils.getQNameFromString(name, element).getLocalPart().equals(resourceProperties.getLocalPart())) continue;
                properties = element;
                break;
            }
            if (properties == null) {
                throw new Exception("Unable to find '" + resourceProperties + "' element in WSDL schema section of '" + this.definition.getDocumentBaseURI() + "' document.");
            }
        }
        String type = properties.getAttribute("type");
        Element complexType = null;
        if (type != null && !type.equals("")) {
            complexTypeElements = schema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "complexType");
            QName typeName = XMLUtils.getFullQNameFromString(type, properties);
            for (int i = 0; i < complexTypeElements.getLength(); ++i) {
                Element currentType = (Element)complexTypeElements.item(i);
                QName currentName = XMLUtils.getFullQNameFromString(currentType.getAttribute("name"), currentType);
                if (!currentName.getLocalPart().equals(typeName.getLocalPart())) continue;
                complexType = currentType;
                break;
            }
            if (complexType == null) {
                throw new Exception("Unable to find type entry for '" + resourceProperties + "' element");
            }
        } else {
            complexTypeElements = properties.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "complexType");
            if (complexTypeElements.getLength() > 0) {
                complexType = (Element)complexTypeElements.item(0);
            } else {
                complexType = doc.createElementNS("http://www.w3.org/2001/XMLSchema", schemaPrefix + "complexType");
                complexType.appendChild(doc.createTextNode("\n          "));
                properties.appendChild(complexType);
                properties.appendChild(doc.createTextNode("\n      "));
            }
        }
        NodeList sequenceElements = complexType.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "sequence");
        if (sequenceElements.getLength() > 0) {
            sequence = (Element)sequenceElements.item(0);
        } else {
            sequence = doc.createElementNS("http://www.w3.org/2001/XMLSchema", schemaPrefix + "sequence");
            complexType.appendChild(sequence);
            complexType.appendChild(doc.createTextNode("\n        "));
        }
        Collection resourcePropertiesList = resourcePropertyElements.values();
        Iterator elementIterator = resourcePropertiesList.iterator();
        int nsCounter = 0;
        while (elementIterator.hasNext()) {
            sequence.appendChild(doc.createTextNode("\n            "));
            Element resourcePropertyElement = doc.createElementNS("http://www.w3.org/2001/XMLSchema", schemaPrefix + "element");
            XSParticle particle = (XSParticle)elementIterator.next();
            XSElementDeclaration element = (XSElementDeclaration)particle.getTerm();
            String prefix = XMLUtils.getPrefix(element.getNamespace(), schema);
            this.addSchemaDefinitions(element, schemaDocumentLocations, schema);
            if (prefix == null) {
                prefix = "rpns" + String.valueOf(nsCounter++);
                Attr nameSpace = doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix);
                nameSpace.setValue(element.getNamespace());
                schema.setAttributeNode(nameSpace);
            }
            resourcePropertyElement.setAttribute("ref", prefix + ":" + element.getName());
            resourcePropertyElement.setAttribute("minOccurs", String.valueOf(particle.getMinOccurs()));
            if (particle.getMaxOccursUnbounded()) {
                resourcePropertyElement.setAttribute("maxOccurs", String.valueOf("unbounded"));
            } else {
                resourcePropertyElement.setAttribute("maxOccurs", String.valueOf(particle.getMaxOccurs()));
            }
            sequence.appendChild(resourcePropertyElement);
        }
        sequence.appendChild(doc.createTextNode("\n          "));
        logger.debug("Resource properties element: " + XMLUtils.ElementToString(properties));
    }

    private void addSchemaDefinitions(XSElementDeclaration element, Map schemaDocumentLocations, Element schema) {
        String elementNS = element.getNamespace();
        this.addSchemaDefinitions(elementNS, schemaDocumentLocations, schema);
    }

    private void addSchemaDefinitions(String elementNS, Map schemaDocumentLocations, Element schema) {
        Map map = (Map)schemaDocumentLocations.get(elementNS);
        if (map == null) {
            return;
        }
        Set locations = map.keySet();
        Iterator locationsIterator = locations.iterator();
        String targetNS = schema.getAttribute("targetNamespace");
        Document owner = schema.getOwnerDocument();
        String schemaPrefix = schema.getPrefix();
        schemaPrefix = schemaPrefix == null ? "" : schemaPrefix + ":";
        this.populateImportsMap(schema);
        this.populateIncludesMap(schema);
        while (locationsIterator.hasNext()) {
            String location = (String)locationsIterator.next();
            if (location.equals(this.definition.getDocumentBaseURI())) continue;
            location = WSDLPreprocessor.getRelativePath(this.definition.getDocumentBaseURI(), location);
            if (elementNS.equals(targetNS)) {
                HashMap<String, Object> includes = (HashMap<String, Object>)this.includes.get(elementNS);
                if (includes == null) {
                    includes = new HashMap<String, Object>();
                    this.includes.put(elementNS, includes);
                }
                if (includes.containsKey(location)) continue;
                Element include = owner.createElementNS("http://www.w3.org/2001/XMLSchema", schemaPrefix + "include");
                include.setAttribute("schemaLocation", location);
                schema.insertBefore(owner.createTextNode("\n"), schema.getFirstChild());
                schema.insertBefore(include, schema.getFirstChild());
                schema.insertBefore(owner.createTextNode("\n"), schema.getFirstChild());
                includes.put(location, null);
                continue;
            }
            HashMap<String, Object> imports = (HashMap<String, Object>)this.imports.get(elementNS);
            if (imports == null) {
                imports = new HashMap<String, Object>();
                this.imports.put(elementNS, imports);
            }
            if (imports.containsKey(location)) continue;
            Element xsdImport = owner.createElementNS("http://www.w3.org/2001/XMLSchema", schemaPrefix + "import");
            xsdImport.setAttribute("namespace", elementNS);
            xsdImport.setAttribute("schemaLocation", location);
            schema.insertBefore(owner.createTextNode("\n"), schema.getFirstChild());
            schema.insertBefore(xsdImport, schema.getFirstChild());
            schema.insertBefore(owner.createTextNode("\n"), schema.getFirstChild());
            imports.put(location, null);
        }
    }

    private void populateImportsMap(Element schema) {
        if (this.imports == null) {
            this.imports = new HashMap();
            NodeList importNodes = schema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "import");
            for (int i = 0; i < importNodes.getLength(); ++i) {
                Element xsdImport = (Element)importNodes.item(i);
                String namespace = xsdImport.getAttribute("namespace") == null ? schema.getAttribute("targetNamespace") : xsdImport.getAttribute("namespace");
                HashMap<String, Object> locations = (HashMap<String, Object>)this.imports.get(namespace);
                if (locations == null) {
                    locations = new HashMap<String, Object>();
                    this.imports.put(namespace, locations);
                }
                locations.put(xsdImport.getAttribute("schemaLocation"), null);
            }
        }
    }

    private void populateIncludesMap(Element schema) {
        if (this.includes == null) {
            this.includes = new HashMap();
            NodeList includeNodes = schema.getElementsByTagNameNS("http://www.w3.org/2001/XMLSchema", "include");
            for (int i = 0; i < includeNodes.getLength(); ++i) {
                Element include = (Element)includeNodes.item(i);
                String namespace = schema.getAttribute("targetNamespace");
                HashMap<String, Object> locations = (HashMap<String, Object>)this.includes.get(namespace);
                if (locations == null) {
                    locations = new HashMap<String, Object>();
                    this.includes.put(namespace, locations);
                }
                locations.put(include.getAttribute("schemaLocation"), null);
            }
        }
    }

    public PortType getPortType(QName portTypeName) throws Exception {
        Map portTypes = this.definition.getPortTypes();
        PortType portType = null;
        if (portTypeName != null) {
            if (portTypeName.getNamespaceURI() == null || portTypeName.getNamespaceURI().length() == 0) {
                portTypeName = new QName(this.definition.getTargetNamespace(), portTypeName.getLocalPart());
            }
            if ((portType = (PortType)portTypes.get(portTypeName)) == null) {
                throw new Exception("PortType not found: " + portTypeName.getLocalPart());
            }
        } else {
            Set portTypeSet = portTypes.entrySet();
            Object[] portTypeArray = portTypeSet.toArray();
            if (portTypeArray.length < 1) {
                throw new Exception("Could not find any portTypes");
            }
            portType = (PortType)((Map.Entry)portTypeArray[0]).getValue();
        }
        return portType;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

