/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.store.buffer.multiplex;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreEntry;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreAccessException;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreException;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.IDemultiplex;
import gr.uoa.di.madgik.grs.store.buffer.multiplex.TimeStruct;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.ArrayList;

public class FirstAvailableDemultiplex
implements IDemultiplex {
    private ArrayList<BufferStoreEntry> entries = null;
    private ArrayList<BufferStoreEntry> activeEntries = null;
    private ArrayList<RecordDefinition[]> definitionsList = null;
    private ArrayList<Long> entryRecordCount = null;
    private RecordWriter<Record> writer = null;
    private TimeStruct timeout = new TimeStruct(10L, ForwardReader.DefaultIteratorTimeUnit);
    private IBufferStore store = null;
    private Object modificationNotify = null;
    private long sendEvents = 0L;

    @Override
    public void setModificationNotify(Object notify) {
        this.modificationNotify = notify;
    }

    @Override
    public void setDefinitionsList(ArrayList<RecordDefinition[]> definitionsList) {
        this.definitionsList = definitionsList;
    }

    @Override
    public void setEntries(ArrayList<BufferStoreEntry> entries) {
        this.entries = entries;
        this.activeEntries = new ArrayList<BufferStoreEntry>(entries);
        this.entryRecordCount = new ArrayList();
        for (BufferStoreEntry entry : this.entries) {
            TimeStruct str = new TimeStruct(entry.getReaderTimeout(), entry.getReaderTimeoutTimeUnit());
            if (this.timeout.compareTo(str) > 0) {
                this.timeout = str;
            }
            this.entryRecordCount.add(new Long(0L));
        }
    }

    @Override
    public void setWriter(RecordWriter<Record> writer) {
        this.writer = writer;
    }

    @Override
    public void setBufferStore(IBufferStore store) {
        this.store = store;
    }

    @Override
    public void dispose() {
        if (this.activeEntries != null) {
            this.activeEntries.clear();
            this.activeEntries = null;
        }
        this.timeout = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void demultiplex() throws GRS2BufferStoreException {
        try {
            this.store.markActivity();
            ArrayList<BufferStoreEntry> inactive = new ArrayList<BufferStoreEntry>();
            while (this.activeEntries.size() != 0 && this.writer.getStatus() == IBuffer.Status.Open) {
                inactive.clear();
                boolean foundSome = false;
                block8: for (int i = 0; i < this.activeEntries.size(); ++i) {
                    Record record;
                    for (long se = this.sendEvents; se < this.entries.get(i).getEventManager().getEventCount(); ++se) {
                        BufferEvent event = this.entries.get(i).getEventManager().retrieveByIndex(se);
                        ++this.sendEvents;
                        this.writer.emit(event);
                    }
                    if (this.entryRecordCount.get(i).longValue() == this.activeEntries.get(i).getRecordManager().getRecordCount() && this.activeEntries.get(i).getStatus() == BufferStoreEntry.EntryStatus.Close) {
                        inactive.add(this.activeEntries.get(i));
                        continue;
                    }
                    while ((record = this.activeEntries.get(i).getRecordManager().retrieveByIndex(this.entryRecordCount.get(i), true)) != null) {
                        this.store.markActivity();
                        foundSome = true;
                        int defCount = 0;
                        for (int d = 0; d < i; ++d) {
                            defCount += this.definitionsList.get(d).length;
                        }
                        record.setDefinitionIndex(defCount + record.getDefinitionIndex());
                        if (!this.writer.put(record, this.timeout.timeout, this.timeout.unit)) continue block8;
                        this.entryRecordCount.set(i, this.entryRecordCount.get(i) + 1L);
                    }
                }
                this.store.markActivity();
                for (BufferStoreEntry entry : inactive) {
                    this.activeEntries.remove(entry);
                }
                if (foundSome) continue;
                Object object = this.modificationNotify;
                synchronized (object) {
                    if (this.activeEntries.size() != 0) {
                        boolean foundavailable = false;
                        for (int i = 0; i < this.activeEntries.size(); ++i) {
                            if (this.entryRecordCount.get(i) >= this.activeEntries.get(i).getRecordManager().getRecordCount()) continue;
                            foundavailable = true;
                        }
                        boolean activeReaders = false;
                        for (int i = 0; i < this.activeEntries.size(); ++i) {
                            if (this.activeEntries.get(i).getStatus() != BufferStoreEntry.EntryStatus.Open) continue;
                            activeReaders = true;
                        }
                        if (!foundavailable && activeReaders) {
                            try {
                                this.modificationNotify.wait(this.timeout.unit.toMillis(this.timeout.timeout));
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            this.store.markActivity();
            if (this.writer.getStatus() != IBuffer.Status.Dispose) {
                this.writer.close();
            }
        }
        catch (GRS2Exception ex) {
            throw new GRS2BufferStoreAccessException("Could not complete multiplexing operation", ex);
        }
    }
}

