/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gram;

import java.io.IOException;
import java.net.Socket;
import java.util.Hashtable;
import org.globus.gram.GramCallbackHandler;
import org.globus.gram.GramJob;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.net.BaseServer;
import org.ietf.jgss.GSSCredential;

public class CallbackHandler
extends BaseServer {
    private Hashtable _jobs;

    public CallbackHandler() throws IOException {
        super(null, 0);
        this.init();
    }

    public CallbackHandler(GSSCredential cred, int port) throws IOException {
        super(cred, port);
        this.init();
    }

    private void init() {
        this._jobs = new Hashtable();
        super.initialize();
        this.setAuthorization(SelfAuthorization.getInstance());
    }

    public void registerJob(GramJob job) {
        String id = job.getIDAsString();
        this._jobs.put(id, job);
    }

    public void unregisterJob(GramJob job) {
        String id = job.getIDAsString();
        this._jobs.remove(id);
    }

    protected GramJob getJob(String url) {
        return (GramJob)this._jobs.get(url);
    }

    public int getRegisteredJobsSize() {
        return this._jobs.size();
    }

    public String getURL() {
        if (this.url == null) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.getProtocol()).append("://").append(this.getHost()).append(":").append(String.valueOf(this.getPort())).append("/").append(String.valueOf(System.currentTimeMillis()));
            this.url = buf.toString();
        }
        return this.url;
    }

    protected void handleConnection(Socket socket) {
        GramCallbackHandler gcb = new GramCallbackHandler(this, socket);
        new Thread(gcb).start();
    }
}

