/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.contexts;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.utils.XMLUtils;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.Builder;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.core.security.context.impl.DefaultGHNClientSecurityContext;
import org.xml.sax.InputSource;

public class GHNClientContext
extends GHNContext {
    private static Map<String, Object> aux_configuration;
    private String etcConfigurationPath;
    public static final String SERVER_WSDD_FILE = "server-config.wsdd";
    private WSDDDocument serverWSDDDocument = null;

    @Override
    protected void initialise() throws Exception {
        try {
            this.etcConfigurationPath = this.getLocation() + File.separatorChar + "etc" + File.separatorChar + "globus_wsrf_core";
            this.serverWSDDDocument = this.loadServerWsddDocument();
            File clientFile = singleton.getFile("GHNConfig.client.xml", new boolean[0]);
            this.configureGHN(clientFile.exists() ? clientFile : this.getFile("GHNConfig.xml", new boolean[0]));
            this.configureGHNResource();
            this.initializeSecurity();
        }
        catch (Throwable e) {
            GHNClientContext.singleton.logger.fatal("gHN could not complete initialisation", e);
        }
    }

    private void initializeSecurity() {
        SecurityContextFactory.getInstance().setSecurityContext(new DefaultGHNClientSecurityContext());
    }

    @Override
    protected void configureGHN(File file) throws Exception {
        super.configureGHN(file);
        aux_configuration = new HashMap<String, Object>();
        NamingEnumeration<Binding> bindings = singleton.getJNDIContext().listBindings("/");
        while (bindings.hasMoreElements()) {
            Binding binding = (Binding)bindings.nextElement();
            aux_configuration.put(binding.getName(), binding.getObject());
        }
    }

    @Override
    protected void configureGHNResource() throws Exception {
        node = GHNContext.getImplementation(GCUBEHostingNode.class);
        node.setLogger(this.logger);
        Builder.createGHNResource(this);
        if (node.addScope(this.getStartScopes()).size() == 0) {
            throw new GCUBEResource.InvalidScopeException();
        }
    }

    @Override
    public Object getProperty(String prop, boolean ... required) throws RuntimeException {
        if (aux_configuration == null) {
            return super.getProperty(prop, required);
        }
        Object value = aux_configuration.get(prop);
        if (value == null && required != null && required.length > 0 && required[0]) {
            throw new RuntimeException("configuration property '" + prop + "' does not exist");
        }
        return value;
    }

    private WSDDDocument loadServerWsddDocument() throws Exception {
        this.logger.debug("Getting Wsdd Document");
        String fileName = this.etcConfigurationPath + File.separatorChar + SERVER_WSDD_FILE;
        this.logger.debug("File = " + fileName);
        WSDDDocument response = new WSDDDocument(XMLUtils.newDocument((InputSource)new InputSource(new FileInputStream(fileName))));
        this.logger.debug("Document loaded");
        return response;
    }

    public WSDDDocument getServerWsddDocument() {
        return this.serverWSDDDocument;
    }
}

