/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.persistence;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.gcube.common.core.persistence.GCUBEWSFilePersistenceDelegate;
import org.gcube.common.core.state.GCUBELocalResource;
import org.gcube.common.core.state.GCUBEResourceHome;
import org.gcube.common.core.state.GCUBEStatefulResource;
import org.gcube.common.core.state.GCUBEWSLiteResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;

public class GCUBEWSLiteFilePersistenceDelegate<LOCAL extends GCUBELocalResource, RESOURCE extends GCUBEWSLiteResource<LOCAL>>
extends GCUBEWSFilePersistenceDelegate<RESOURCE> {
    protected static final String WSLITE_FILE_SUFFIX = ".wslite";

    @Override
    public void initialise(GCUBEResourceHome<? super GCUBEWSResourceKey, GCUBEWSResourceKey, RESOURCE> home) throws Exception {
        super.initialise(home);
        Class<?> resourceClass = this.getClass().getClassLoader().loadClass(home.getResourceClass());
        if (!GCUBEWSLiteResource.class.isAssignableFrom(resourceClass)) {
            throw new Exception(home.getResourceClass() + " is not compatible with delegate " + this.getClass().getSimpleName());
        }
    }

    @Override
    protected void onLoad(RESOURCE resource, ObjectInputStream stream) throws Exception {
        super.onLoad(resource, stream);
        ((GCUBEWSLiteResource)resource).setLocalID((String)stream.readObject());
    }

    @Override
    public synchronized void onStore(RESOURCE resource) throws Exception {
        ((GCUBEStatefulResource)((GCUBEWSLiteResource)resource).getLocalResource()).store();
        super.onStore(resource);
    }

    @Override
    protected void onStore(RESOURCE resource, ObjectOutputStream stream) throws Exception {
        super.onStore(resource, stream);
        stream.writeObject(((GCUBEWSLiteResource)resource).getLocalID());
    }

    @Override
    protected String getSuffix() {
        return WSLITE_FILE_SUFFIX;
    }
}

