/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.security.impl;

import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authorization.ServiceAuthorizationChain;
import org.globus.wsrf.impl.security.authorization.exceptions.AuthorizationException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ResourceSecurityDescriptor;
import org.globus.wsrf.impl.security.descriptor.SecureResourcePropertiesHelper;
import org.globus.wsrf.impl.security.descriptor.SecurityPropertiesHelper;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.impl.security.util.PDPUtils;
import org.globus.wsrf.utils.ContextUtils;

public class GCUBEAuthzChainAuthorizationController
implements GCUBEServiceAuthorizationController {
    protected GCUBELog logger = new GCUBELog(this);
    private ServiceAuthorizationChain authzChain = null;
    private GCUBEServiceSecurityManager securityManager;

    @Override
    public void initialise(GCUBEServiceContext ctxt, GCUBEServiceSecurityManager securityManager) throws Exception {
        this.authzChain = null;
        this.securityManager = securityManager;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void authoriseCall(Map<String, Object> authzMap) throws GCUBEException {
        this.logger.debug("starting authorization process...");
        if (this.isSecurityEnabled()) {
            org.apache.axis.MessageContext messageContext = (org.apache.axis.MessageContext)authzMap.get("MESSAGE_CONTEXT");
            if (messageContext == null) throw new GCUBEUnrecoverableException("Message context not found");
            this.logger.debug("authorizing...");
            this.performAuthorisation(messageContext);
            this.logger.debug("authorization process completed: authorization granted");
            return;
        } else {
            this.logger.debug("Security not enabled");
        }
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityManager.isSecurityEnabled();
    }

    private void performAuthorisation(org.apache.axis.MessageContext messageContext) throws GCUBEUnrecoverableException {
        this.logger.debug("Authorization");
        Subject subject = (Subject)messageContext.getProperty("callerSubject");
        if (subject == null) {
            this.logger.debug("No authenticaiton done, so no authz");
            return;
        }
        String servicePath = ContextUtils.getTargetServicePath((org.apache.axis.MessageContext)messageContext);
        if (servicePath == null) {
            return;
        }
        this.logger.debug("Service path " + servicePath);
        if (this.authzChain == null) {
            this.authzChain = this.generateServiceAuthzChain(messageContext, servicePath);
        }
        if (this.authzChain != null) {
            this.logger.debug("Invoking authorize on authz chain");
            try {
                this.authzChain.authorize(subject, (MessageContext)messageContext, servicePath);
            }
            catch (AuthorizationException e) {
                this.logger.error("Authorization failed", e);
                throw new GCUBEUnrecoverableException(e);
            }
            finally {
                try {
                    this.authzChain.close();
                }
                catch (CloseException e) {
                    throw new GCUBEUnrecoverableException(e);
                }
            }
        }
        this.logger.debug("Unable to retrieve authz chain");
    }

    private ServiceAuthorizationChain generateServiceAuthzChain(org.apache.axis.MessageContext messageContext, String servicePath) throws GCUBEUnrecoverableException {
        this.logger.debug("Generating Security Descriptor");
        ServiceAuthorizationChain authzChain = null;
        Resource resource = null;
        try {
            ResourceContext context = ResourceContext.getResourceContext((SOAPMessageContext)messageContext);
            resource = context.getResource();
        }
        catch (ResourceContextException exp) {
            resource = null;
            this.logger.debug("Error getting resource/may not exist", exp);
        }
        catch (ResourceException exp) {
            resource = null;
            this.logger.debug("Error getting resource/may not exist", exp);
        }
        this.logger.debug("Resource is null: " + (resource == null));
        ResourceSecurityDescriptor secDesc = null;
        if (resource != null && (secDesc = SecureResourcePropertiesHelper.getResourceSecDescriptor((Resource)resource)) != null) {
            try {
                authzChain = SecureResourcePropertiesHelper.getAuthzChain((Resource)resource);
            }
            catch (ConfigException exp) {
                throw new GCUBEUnrecoverableException(exp);
            }
        }
        if (authzChain == null) {
            try {
                ContainerSecurityConfig config = ContainerSecurityConfig.getConfig();
                secDesc = config.getSecurityDescriptor();
                if (secDesc != null) {
                    authzChain = secDesc.getAuthzChain();
                }
                if (authzChain == null && config.getSecurityDescriptorFile() == null) {
                    this.logger.debug("Insecure container");
                    secDesc = null;
                }
            }
            catch (ConfigException exp) {
                throw new GCUBEUnrecoverableException(exp);
            }
        }
        this.logger.debug("Sec desc after container is not null: " + (secDesc != null));
        if (secDesc != null && authzChain == null) {
            this.logger.debug("Insecure setting, return");
            this.logger.debug("Sec desc is present, default authz chain");
            String authzString = this.getDefaultAuthzChain(servicePath, resource);
            try {
                authzChain = PDPUtils.getServiceAuthzChain((String)authzString, (String)servicePath);
            }
            catch (ConfigException exp) {
                throw new GCUBEUnrecoverableException(exp);
            }
        }
        return authzChain;
    }

    private String getDefaultAuthzChain(String servicePath, Resource resource) {
        boolean gridMapPresent;
        this.logger.debug("Getting the default authorization chain");
        String interceptor = null;
        try {
            gridMapPresent = SecurityPropertiesHelper.gridMapPresent((String)servicePath, (Resource)resource);
            this.logger.debug("gridmap present" + gridMapPresent);
        }
        catch (ConfigException exp) {
            gridMapPresent = false;
            this.logger.debug("gridmap present" + gridMapPresent + " for configuration error");
        }
        if (!gridMapPresent) {
            this.logger.debug("Self authorization");
            interceptor = AuthUtil.getPDPName((String)"self");
        } else {
            this.logger.debug("gridmap authorization");
            interceptor = AuthUtil.getPDPName((String)"gridmap");
        }
        return interceptor;
    }
}

