/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.handlers;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.StringTokenizer;

public class GCUBEURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String protocolPathProp = "java.protocol.handler.pkgs";

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        String packagePrefixList = System.getProperty(protocolPathProp);
        URLStreamHandler handler = null;
        if (packagePrefixList != null) {
            StringTokenizer packagePrefixIter = new StringTokenizer(packagePrefixList, "|");
            while (handler == null && packagePrefixIter.hasMoreTokens()) {
                String packagePrefix = packagePrefixIter.nextToken().trim();
                try {
                    Class<?> cls;
                    block6: {
                        String clsName = packagePrefix + "." + protocol + ".Handler";
                        cls = null;
                        try {
                            cls = Class.forName(clsName);
                        }
                        catch (ClassNotFoundException e) {
                            ClassLoader cl = ClassLoader.getSystemClassLoader();
                            if (cl == null) break block6;
                            cls = cl.loadClass(clsName);
                        }
                    }
                    if (cls == null) continue;
                    handler = (URLStreamHandler)cls.newInstance();
                }
                catch (Exception e) {}
            }
        }
        return handler;
    }
}

