/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset.elements;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Vector;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.RecordAttribute;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.ResultElementGeneric;

public class ResultElementBean
extends ResultElementGeneric {
    public static String RECORD_BEAN_NAME = "Bean";
    private Object bean = null;

    public ResultElementBean() {
    }

    public ResultElementBean(String id, String collection, Object bean) throws Exception {
        Vector<RecordAttribute> at = new Vector<RecordAttribute>();
        at.add(new RecordAttribute("DocID", id));
        at.add(new RecordAttribute("CollID", collection));
        at.add(new RecordAttribute(RECORD_BEAN_NAME, bean.getClass().getName()));
        at.add(new RecordAttribute("RankID", "1.0"));
        this.setRecordAttributes(at.toArray(new RecordAttribute[0]));
        this.bean = bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getBeanClassName() throws Exception {
        try {
            return this.getRecordAttributes(RECORD_BEAN_NAME)[0].getAttrValue();
        }
        catch (Exception e) {
            throw new Exception("No bean name found.");
        }
    }

    @Override
    public String toXML() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        XMLEncoder encoder = new XMLEncoder(os);
        encoder.writeObject(this.bean);
        encoder.close();
        return os.toString().substring(os.toString().indexOf("<java version"));
    }

    @Override
    public void fromXML(String xml) throws Exception {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes());
            XMLDecoder decoder = new XMLDecoder(is);
            this.setBean(decoder.readObject());
        }
        catch (Exception e) {
            throw new Exception("provided xml string is not valid ResultSelement serialization", e);
        }
    }
}

