/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.stubs;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;
import org.gcube.informationsystem.collector.stubs.Entry;
import org.gcube.informationsystem.collector.stubs.EntryPortType;
import org.gcube.informationsystem.collector.stubs.EntryPortTypeSOAPBindingStub;

public class EntryLocator
extends Service
implements Entry {
    private String IC_address = "http://localhost:8080/wsrf/services/";
    private String ICWSDDServiceName = "IC";
    private HashSet ports = null;

    public EntryLocator() {
    }

    public EntryLocator(EngineConfiguration config) {
        super(config);
    }

    public EntryLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    @Override
    public String getICAddress() {
        return this.IC_address;
    }

    public String getICWSDDServiceName() {
        return this.ICWSDDServiceName;
    }

    public void setICWSDDServiceName(String name) {
        this.ICWSDDServiceName = name;
    }

    @Override
    public EntryPortType getIC() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.IC_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getIC(endpoint);
    }

    @Override
    public EntryPortType getIC(URL portAddress) throws ServiceException {
        try {
            EntryPortTypeSOAPBindingStub _stub = new EntryPortTypeSOAPBindingStub(portAddress, this);
            _stub.setPortName(this.getICWSDDServiceName());
            return _stub;
        }
        catch (AxisFault e) {
            return null;
        }
    }

    public void setICEndpointAddress(String address) {
        this.IC_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (EntryPortType.class.isAssignableFrom(serviceEndpointInterface)) {
                EntryPortTypeSOAPBindingStub _stub = new EntryPortTypeSOAPBindingStub(new URL(this.IC_address), this);
                _stub.setPortName(this.getICWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("IC".equals(inputPortName)) {
            return this.getIC();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://gcube-system.org/namespaces/informationsystem/collector", "Entry");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://gcube-system.org/namespaces/informationsystem/collector", "IC"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"IC".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setICEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

