/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.collector.stubs.testsuite.wsdaix;

import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.informationsystem.collector.stubs.wsdai.DataResourceUnavailableFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.InvalidResourceNameFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.NotAuthorizedFaultType;
import org.gcube.informationsystem.collector.stubs.wsdai.ServiceBusyFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.GetDocumentRequestWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.GetDocumentResponseWrapper;
import org.gcube.informationsystem.collector.stubs.wsdaix.GetDocumentsRequest;
import org.gcube.informationsystem.collector.stubs.wsdaix.GetDocumentsResponse;
import org.gcube.informationsystem.collector.stubs.wsdaix.InvalidCollectionNameFaultType;
import org.gcube.informationsystem.collector.stubs.wsdaix.XMLCollectionAccessPT;
import org.gcube.informationsystem.collector.stubs.wsdaix.XMLWrapperType;
import org.gcube.informationsystem.collector.stubs.wsdaix.service.WsdaixServiceAddressingLocator;
import org.w3c.dom.Document;

public class GetDocumentsTester {
    private static GCUBEClientLog logger = new GCUBEClientLog(GetDocumentsTester.class, new Properties[0]);

    public static void main(String[] args) {
        String portTypeURI = "http://" + args[0] + ":" + args[1] + "/wsrf/services/gcube/informationsystem/collector/wsdaix/XMLCollectionAccess";
        try {
            GetDocumentResponseWrapper[] wrappers;
            GetDocumentsResponse response = GetDocumentsTester.getDocuments(portTypeURI, GCUBEScope.getScope((String)args[2]), new URI("gcube://" + args[4]), new URI(args[3]), new String[]{args[4]});
            for (GetDocumentResponseWrapper wrapper : wrappers = response.getGetDocumentResponseWrapper()) {
                logger.info((Object)("Document name " + wrapper.getDocumentName()));
                logger.info((Object)("Document response " + wrapper.getResponse().toString()));
                XMLWrapperType xmlwrapper = wrapper.getData();
                MessageElement elem = xmlwrapper.get_any()[0];
                Document o = elem.getAsDocument();
                if (!(o instanceof Document)) {
                    throw new Exception("Unable to read the resource: a problem when deserializing the document occurred");
                }
                Document doc = o;
                TransformerFactory transFactory = TransformerFactory.newInstance();
                Transformer transformer = transFactory.newTransformer();
                StringWriter buffer = new StringWriter();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.transform(new DOMSource(doc), new StreamResult(buffer));
                logger.info((Object)"Document returned: ");
                logger.info((Object)buffer.toString());
            }
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
    }

    public static GetDocumentsResponse getDocuments(String serviceURL, GCUBEScope scope, URI resourceName, URI collectionURI, String[] documentNames) throws DataResourceUnavailableFaultType, MalformedURLException, RemoteException, ServiceBusyFaultType, InvalidResourceNameFaultType, InvalidCollectionNameFaultType, NotAuthorizedFaultType {
        GetDocumentsRequest request = new GetDocumentsRequest();
        request.setDataResourceAbstractName(resourceName);
        GetDocumentRequestWrapper[] wrappers = new GetDocumentRequestWrapper[documentNames.length];
        for (int i = 0; i < wrappers.length; ++i) {
            wrappers[i] = new GetDocumentRequestWrapper();
            wrappers[i].setDocumentName(documentNames[i]);
        }
        request.setGetDocumentRequestWrapper(wrappers);
        request.setCollectionName(collectionURI);
        XMLCollectionAccessPT stubs = null;
        try {
            stubs = new WsdaixServiceAddressingLocator().getXMLCollectionAccessPTPort(new URL(serviceURL));
            stubs = (XMLCollectionAccessPT)GCUBERemotePortTypeContext.getProxy((Remote)stubs, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (Exception e) {
            logger.error((Object)"Failed to get documentes", (Throwable)e);
        }
        return stubs.getDocuments(request);
    }
}

