/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.servicegroup;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.naming.InitialContext;
import org.apache.axis.MessageContext;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.ResourceHome;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.impl.servicegroup.ServiceGroupConstants;
import org.globus.wsrf.impl.servicegroup.ServiceGroupEntryResource;
import org.globus.wsrf.impl.servicegroup.ServiceGroupResource;
import org.oasis.wsrf.servicegroup.EntryType;

public class EntryResourceProperty
extends ReflectionResourceProperty {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$impl$servicegroup$EntryResourceProperty == null ? (class$org$globus$wsrf$impl$servicegroup$EntryResourceProperty = EntryResourceProperty.class$("org.globus.wsrf.impl.servicegroup.EntryResourceProperty")) : class$org$globus$wsrf$impl$servicegroup$EntryResourceProperty).getName());
    ServiceGroupResource serviceGroupResource;
    ResourceHome entryHome = null;
    static /* synthetic */ Class class$org$globus$wsrf$impl$servicegroup$EntryResourceProperty;

    public EntryResourceProperty(ServiceGroupResource sgr) throws Exception {
        super((ResourcePropertyMetaData)new SimpleResourcePropertyMetaData(ServiceGroupConstants.ENTRY));
        this.serviceGroupResource = sgr;
        this.setObject((Object)this);
        this.setPropertyName("DynamicValue");
        this.initialize();
        try {
            this.entryHome = EntryResourceProperty.getEntryHome();
        }
        catch (Exception e) {
            logger.error((Object)"Exception getting entry home", (Throwable)e);
        }
    }

    public Object[] getDynamicValue() {
        Vector<EntryType> results = new Vector<EntryType>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Generating value of Entry RP.");
        }
        Iterator entryIterator = this.serviceGroupResource.iterateEntryValues();
        while (entryIterator.hasNext()) {
            Object entryResource = null;
            ResourcePropertySet rpSet = null;
            ResourceProperty contentProperty = null;
            ResourceProperty memberEPRProperty = null;
            Object contentValue = null;
            Object memberEPR = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Assembling an entry RP (" + results.size() + " so far)"));
            }
            try {
                Map.Entry mapEntry = (Map.Entry)entryIterator.next();
                entryResource = mapEntry.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Assembling entry RP to represent " + entryResource));
                }
                if (entryResource != null) {
                    EntryType entry = new EntryType();
                    rpSet = ((ResourceProperties)entryResource).getResourcePropertySet();
                    if (rpSet != null) {
                        contentProperty = rpSet.get(ServiceGroupConstants.CONTENT);
                    }
                    if (contentProperty == null) {
                        logger.warn((Object)"Could not get Content from ServiceGroupEntry -- RP does not exist");
                    } else {
                        try {
                            contentValue = contentProperty.get(0);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (contentValue == null) {
                            logger.warn((Object)"Could not get Content from ServiceGroupEntry resource -- RP exists but has no value.");
                        } else {
                            entry.setContent((Object)new Object[]{contentValue});
                        }
                    }
                    if (rpSet != null) {
                        memberEPRProperty = rpSet.get(ServiceGroupConstants.MEMBER_EPR);
                    }
                    if (memberEPRProperty == null) {
                        logger.warn((Object)"Could not get Member EPR from ServiceGroupEntry -- RP does not exist");
                    } else {
                        try {
                            memberEPR = memberEPRProperty.get(0);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (memberEPR instanceof EndpointReferenceType) {
                            entry.setMemberServiceEPR((EndpointReferenceType)memberEPR);
                        } else if (memberEPR == null) {
                            logger.warn((Object)"Could not get Member EPR from ServiceGroupEntry resource -- RP exists but has no value.");
                        } else {
                            logger.warn((Object)"Could not get Member EPR from ServiceGroupEntry resource -- RP value is incorrect type.");
                        }
                    }
                    entry.setServiceGroupEntryEPR(((ServiceGroupEntryResource)entryResource).getEntryEPR());
                    results.add(entry);
                    continue;
                }
                logger.warn((Object)"Found a null service group entry value in ServiceGroupResource - skipping");
            }
            catch (Exception e) {
                logger.warn((Object)"Truncated Entry RP due to an unhandled exception during assembly", (Throwable)e);
                break;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Total number of Entry RP values is " + results.size()));
        }
        return results.toArray();
    }

    public static ResourceHome getEntryHome() throws Exception {
        MessageContext ctx = MessageContext.getCurrentContext();
        String homeLocation = EntryResourceProperty.getEntryHomeLocation(ctx);
        InitialContext initialContext = new InitialContext();
        return (ResourceHome)initialContext.lookup(homeLocation);
    }

    public static String getEntryHomeLocation(MessageContext ctx) throws Exception {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx == null");
        }
        if (!(ctx instanceof MessageContext)) {
            throw new Exception("ctx must be Axis instance");
        }
        MessageContext context = ctx;
        String servicePath = context.getTargetService();
        return "java:comp/env//services/" + servicePath + "/entryHome";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

