/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tomcat.coyote.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.http11.InternalInputBuffer;
import org.globus.tomcat.catalina.net.HTTPSSocket;
import org.ietf.jgss.GSSContext;

public final class HTTPSValve55
extends ValveBase {
    protected static final String info = "org.globus.tomcat.catalina.valves.HTTPSTransportValve/1.0";

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.expose(request);
        this.getNext().invoke(request, response);
    }

    private HTTPSSocket getSocketFromInputStream(org.apache.coyote.Request request) {
        InternalInputBuffer internalInputBuffer;
        InputBuffer inputBuffer = request.getInputBuffer();
        if (inputBuffer instanceof InternalInputBuffer && (internalInputBuffer = (InternalInputBuffer)inputBuffer).getInputStream() instanceof HTTPSSocket.SocketGSIGssInputStream) {
            HTTPSSocket.SocketGSIGssInputStream in = (HTTPSSocket.SocketGSIGssInputStream)((Object)internalInputBuffer.getInputStream());
            return in.getSocket();
        }
        return null;
    }

    protected void expose(Request request) {
        HTTPSSocket socket = this.getSocketFromInputStream(request.getCoyoteRequest());
        if (socket != null) {
            request.getCoyoteRequest().scheme().setString("https");
            String globusID = socket.getUserDN();
            if (globusID != null) {
                request.getRequest().setAttribute("org.globus.gsi.authorized.user.dn", (Object)globusID);
            }
            GSSContext context = socket.getContext();
            request.getRequest().setAttribute("org.globus.gsi.context", (Object)context);
        }
    }
}

