/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.ghnmanager.impl.platforms;

import java.io.File;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.ghnmanager.impl.platforms.GHNPlatforms;
import org.gcube.common.vremanagement.ghnmanager.impl.platforms.PlatformCall;
import org.gcube.vremanagement.virtualplatform.image.PlatformConfiguration;
import org.gcube.vremanagement.virtualplatform.image.Platforms;
import org.gcube.vremanagement.virtualplatform.image.VirtualPlatform;

public class PlatformMonitor
implements Runnable {
    protected GCUBELog logger = new GCUBELog(PlatformMonitor.class);
    private boolean firstExecution = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List platforms;
        List list = platforms = GHNContext.getContext().getGHN().getNodeDescription().getAvailablePlatforms();
        synchronized (list) {
            this.logger.trace((Object)"Checking the available platforms");
            platforms.clear();
            List configurations = Platforms.listAvailablePlatforms((File)new File(GHNContext.getContext().getVirtualPlatformsLocation()));
            for (PlatformConfiguration config : configurations) {
                this.logger.trace((Object)("Found configuration " + config.getName()));
                try {
                    VirtualPlatform vp = GHNPlatforms.get(config);
                    if (!vp.isAvailable()) {
                        new PlatformCall(GHNPlatforms.get(config)).initialize();
                    } else if (this.firstExecution) {
                        new PlatformCall(GHNPlatforms.get(config)).activateAllInstances();
                    }
                    if (vp.isAvailable()) {
                        PlatformDescription pd = new PlatformDescription();
                        pd.setName(config.getName());
                        pd.setMinorVersion(config.getMinorVersion());
                        pd.setVersion(config.getVersion());
                        platforms.add(pd);
                        this.logger.trace((Object)("Platform " + config.getName() + " is available"));
                        continue;
                    }
                    this.logger.warn((Object)("Platform " + config.getName() + " is not available"));
                    new PlatformCall(GHNPlatforms.get(config)).shutdown();
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Platform " + config.getName() + " is not available"), (Throwable)e);
                }
            }
        }
        this.firstExecution = false;
    }
}

