/*
 * Decompiled with CFR 0.152.
 */
package COM.claymoresystems.cert;

import COM.claymoresystems.cert.CertificateException;
import COM.claymoresystems.cert.Pickledx509;
import COM.claymoresystems.cert.X509Cert;
import COM.claymoresystems.ptls.SSLDebug;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.ParseException;
import cryptix.asn1.lang.Parser;
import cryptix.util.core.ArrayUtil;
import java.io.Reader;
import java.util.Vector;

public class CertContext {
    Vector root_list = new Vector();
    static Parser parser = new Parser((Reader)new Pickledx509());
    static ASNSpecification spec;

    public CertContext() {
    }

    public CertContext(Vector roots) {
        if (roots != null) {
            int i = 0;
            while (i < roots.size()) {
                Object obj = roots.elementAt(i);
                if (obj instanceof X509Cert) {
                    this.root_list.addElement(obj);
                } else {
                    this.addRoot((byte[])roots.elementAt(i));
                }
                ++i;
            }
        }
    }

    public static ASNSpecification getSpec() {
        return spec;
    }

    public void addRoot(byte[] root_ber) {
        X509Cert cert;
        try {
            cert = new X509Cert(root_ber);
        }
        catch (CertificateException e) {
            SSLDebug.debug(32, "Couldn't parse. Skipping cert", root_ber);
            return;
        }
        this.root_list.addElement(cert);
        SSLDebug.debug(32, "Adding root with DN", cert.getSubjectDER());
    }

    public Vector getRootList() {
        return this.root_list;
    }

    public boolean isRoot(byte[] cert) {
        int i = 0;
        while (i < this.root_list.size()) {
            byte[] root = ((X509Cert)this.root_list.elementAt(i)).getDER();
            if (ArrayUtil.areEqual((byte[])cert, (byte[])root)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public X509Cert signedByRoot(byte[] issuer) {
        int i = 0;
        while (i < this.root_list.size()) {
            X509Cert root = (X509Cert)this.root_list.elementAt(i);
            byte[] subject = root.getSubjectDER();
            if (ArrayUtil.areEqual((byte[])issuer, (byte[])subject)) {
                return root;
            }
            ++i;
        }
        return null;
    }

    static {
        parser.disable_tracing();
        try {
            spec = parser.Specification(false);
        }
        catch (ParseException e) {
            throw new InternalError(e.toString());
        }
    }
}

