/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.Session;
import org.globus.ftp.dc.DataChannel;
import org.globus.ftp.dc.DataChannelReader;
import org.globus.ftp.dc.DataChannelWriter;
import org.globus.ftp.dc.EBlockAware;
import org.globus.ftp.dc.EBlockParallelTransferContext;
import org.globus.ftp.dc.TransferContext;

public abstract class AbstractDataChannel
implements DataChannel {
    private static Log logger = LogFactory.getLog((String)(class$org$globus$ftp$dc$AbstractDataChannel == null ? (class$org$globus$ftp$dc$AbstractDataChannel = AbstractDataChannel.class$("org.globus.ftp.dc.AbstractDataChannel")) : class$org$globus$ftp$dc$AbstractDataChannel).getName());
    protected Session session;
    protected static Map dataHandlers;
    private static final int SOURCE = 1;
    private static final int SINK = 2;
    static /* synthetic */ Class class$org$globus$ftp$dc$AbstractDataChannel;
    static /* synthetic */ Class class$org$globus$ftp$dc$StreamImageDCReader;
    static /* synthetic */ Class class$org$globus$ftp$dc$StreamAsciiDCReader;
    static /* synthetic */ Class class$org$globus$ftp$dc$StreamImageDCWriter;
    static /* synthetic */ Class class$org$globus$ftp$dc$StreamAsciiDCWriter;
    static /* synthetic */ Class class$org$globus$ftp$dc$EBlockImageDCReader;
    static /* synthetic */ Class class$org$globus$ftp$dc$EBlockImageDCWriter;
    static /* synthetic */ Class class$org$globus$ftp$dc$DataChannelReader;
    static /* synthetic */ Class class$org$globus$ftp$dc$DataChannelWriter;

    public AbstractDataChannel(Session session) {
        this.session = session;
    }

    public static void registerHandler(int transferMode, int transferType, int type, Class clazz) throws Exception {
        switch (type) {
            case 1: {
                if ((class$org$globus$ftp$dc$DataChannelReader == null ? (class$org$globus$ftp$dc$DataChannelReader = AbstractDataChannel.class$("org.globus.ftp.dc.DataChannelReader")) : class$org$globus$ftp$dc$DataChannelReader).isAssignableFrom(clazz)) break;
                throw new Exception("Incorrect type");
            }
            case 2: {
                if ((class$org$globus$ftp$dc$DataChannelWriter == null ? (class$org$globus$ftp$dc$DataChannelWriter = AbstractDataChannel.class$("org.globus.ftp.dc.DataChannelWriter")) : class$org$globus$ftp$dc$DataChannelWriter).isAssignableFrom(clazz)) break;
                throw new Exception("Incorrect type");
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + type);
            }
        }
        String id = AbstractDataChannel.getHandlerID(transferMode, transferType, type);
        if (dataHandlers == null) {
            dataHandlers = new HashMap();
        }
        logger.debug((Object)("registering handler for class " + clazz.toString() + "; id = " + id));
        dataHandlers.put(id, clazz);
    }

    public boolean isDataSourceModeSupported() {
        String id = AbstractDataChannel.getHandlerID(this.session.transferMode, this.session.transferType, 1);
        return dataHandlers.get(id) != null;
    }

    public boolean isDataSinkModeSupported() {
        String id = AbstractDataChannel.getHandlerID(this.session.transferMode, this.session.transferType, 2);
        return dataHandlers.get(id) != null;
    }

    public DataChannelReader getDataChannelSource(TransferContext context) throws Exception {
        String id = AbstractDataChannel.getHandlerID(this.session.transferMode, this.session.transferType, 1);
        logger.debug((Object)("type/mode: " + id));
        Class clazz = (Class)dataHandlers.get(id);
        if (clazz == null) {
            throw new Exception("No data reader for type/mode" + id);
        }
        DataChannelReader reader = (DataChannelReader)clazz.newInstance();
        if (reader instanceof EBlockAware) {
            ((EBlockAware)((Object)reader)).setTransferContext((EBlockParallelTransferContext)context);
        }
        return reader;
    }

    public DataChannelWriter getDataChannelSink(TransferContext context) throws Exception {
        String id = AbstractDataChannel.getHandlerID(this.session.transferMode, this.session.transferType, 2);
        Class clazz = (Class)dataHandlers.get(id);
        if (clazz == null) {
            throw new Exception("No data reader for type/mode");
        }
        DataChannelWriter writer = (DataChannelWriter)clazz.newInstance();
        if (writer instanceof EBlockAware) {
            ((EBlockAware)((Object)writer)).setTransferContext((EBlockParallelTransferContext)context);
        }
        return writer;
    }

    private static String getHandlerID(int transferMode, int transferType, int type) {
        String id = "";
        switch (transferMode) {
            case 1: {
                id = id + "S-";
                break;
            }
            case 3: {
                id = id + "E-";
                break;
            }
            default: {
                throw new IllegalArgumentException("Mode not supported: " + transferMode);
            }
        }
        switch (transferType) {
            case 1: {
                id = id + "I-";
                break;
            }
            case 2: {
                id = id + "A-";
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + transferType);
            }
        }
        switch (type) {
            case 1: {
                id = id + "R";
                break;
            }
            case 2: {
                id = id + "W";
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + type);
            }
        }
        if (id.equals("")) {
            return null;
        }
        return id;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            AbstractDataChannel.registerHandler(1, 1, 1, class$org$globus$ftp$dc$StreamImageDCReader == null ? (class$org$globus$ftp$dc$StreamImageDCReader = AbstractDataChannel.class$("org.globus.ftp.dc.StreamImageDCReader")) : class$org$globus$ftp$dc$StreamImageDCReader);
            AbstractDataChannel.registerHandler(1, 2, 1, class$org$globus$ftp$dc$StreamAsciiDCReader == null ? (class$org$globus$ftp$dc$StreamAsciiDCReader = AbstractDataChannel.class$("org.globus.ftp.dc.StreamAsciiDCReader")) : class$org$globus$ftp$dc$StreamAsciiDCReader);
            AbstractDataChannel.registerHandler(1, 1, 2, class$org$globus$ftp$dc$StreamImageDCWriter == null ? (class$org$globus$ftp$dc$StreamImageDCWriter = AbstractDataChannel.class$("org.globus.ftp.dc.StreamImageDCWriter")) : class$org$globus$ftp$dc$StreamImageDCWriter);
            AbstractDataChannel.registerHandler(1, 2, 2, class$org$globus$ftp$dc$StreamAsciiDCWriter == null ? (class$org$globus$ftp$dc$StreamAsciiDCWriter = AbstractDataChannel.class$("org.globus.ftp.dc.StreamAsciiDCWriter")) : class$org$globus$ftp$dc$StreamAsciiDCWriter);
            AbstractDataChannel.registerHandler(3, 1, 1, class$org$globus$ftp$dc$EBlockImageDCReader == null ? (class$org$globus$ftp$dc$EBlockImageDCReader = AbstractDataChannel.class$("org.globus.ftp.dc.EBlockImageDCReader")) : class$org$globus$ftp$dc$EBlockImageDCReader);
            AbstractDataChannel.registerHandler(3, 1, 2, class$org$globus$ftp$dc$EBlockImageDCWriter == null ? (class$org$globus$ftp$dc$EBlockImageDCWriter = AbstractDataChannel.class$("org.globus.ftp.dc.EBlockImageDCWriter")) : class$org$globus$ftp$dc$EBlockImageDCWriter);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to install default data channel handlers: " + e.getMessage());
        }
    }
}

