/*
 * Decompiled with CFR 0.152.
 */
package org.globus.net;

import java.net.URL;
import java.net.URLConnection;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.GSSAuthorization;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;

public abstract class GSIURLConnection
extends URLConnection {
    public static final String GSS_MODE_PROPERTY = "gssMode";
    protected GSSCredential credentials;
    protected Authorization authorization = null;
    protected int delegationType = 1;
    protected Integer gssMode;

    protected GSIURLConnection(URL url) {
        super(url);
    }

    public abstract void disconnect();

    public void setGSSMode(Integer mode) {
        this.gssMode = mode;
    }

    public Integer getGSSMode() {
        return this.gssMode;
    }

    public void setCredentials(GSSCredential credentials) {
        this.credentials = credentials;
    }

    public GSSCredential getCredentials() {
        return this.credentials;
    }

    public void setAuthorization(Authorization auth) {
        this.authorization = auth;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    public void setDelegationType(int delegationType) {
        this.delegationType = delegationType;
    }

    public int getDelegationType() {
        return this.delegationType;
    }

    protected GSSName getExpectedName() throws GSSException {
        if (this.authorization instanceof GSSAuthorization) {
            GSSAuthorization auth = (GSSAuthorization)this.authorization;
            return auth.getExpectedName(this.credentials, this.url.getHost());
        }
        return null;
    }

    public void setRequestProperty(String key, String value) {
        if (key.equals(GSS_MODE_PROPERTY)) {
            if (value.equals("ssl")) {
                this.setGSSMode(GSIConstants.MODE_SSL);
            } else if (value.equals("gsi")) {
                this.setGSSMode(GSIConstants.MODE_GSI);
            } else {
                this.setGSSMode(null);
            }
        } else {
            super.setRequestProperty(key, value);
        }
    }
}

