/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.proxy;

import javax.swing.JLabel;
import javax.swing.JTextField;
import org.globus.common.CoGProperties;
import org.globus.tools.proxy.ProxyOptionsPanel;

public class PKCS11ProxyOptionsPanel
extends ProxyOptionsPanel {
    protected JTextField certHandleTF;
    protected JTextField keyHandleTF;

    public PKCS11ProxyOptionsPanel() {
        this.setInsets(2, 2, 2, 2);
        this.setAnchor(13);
        this.gbc.weightx = 0.0;
        this.setFill(0);
        this.add(new JLabel("User Certificate Handle: "), 0, 4, 1, 1);
        this.add(new JLabel("User Private Handle: "), 0, 5, 1, 1);
        this.setAnchor(17);
        this.gbc.weightx = 1.0;
        this.setFill(2);
        this.certHandleTF = new JTextField(20);
        this.add(this.certHandleTF, 1, 4, 1, 1);
        this.keyHandleTF = new JTextField(20);
        this.add(this.keyHandleTF, 1, 5, 1, 1);
    }

    public boolean validateSettings() {
        if (!super.validateSettings()) {
            return false;
        }
        if (this.certHandleTF.getText().equals("") && this.keyHandleTF.getText().equals("")) {
            return this.error("Please enter the certificate or the private key handle.");
        }
        return true;
    }

    public void set(CoGProperties props) {
        super.set(props);
        String certH = props.getProperty("pkcs11.certhandle");
        String keyH = props.getProperty("pkcs11.keyhandle");
        if (certH == null || certH.length() == 0) {
            certH = keyH == null || keyH.length() == 0 ? (keyH = props.getDefaultPKCS11Handle()) : keyH;
        } else if (keyH == null || keyH.length() == 0) {
            keyH = certH;
        }
        this.certHandleTF.setText(certH);
        this.keyHandleTF.setText(keyH);
    }

    public void get(CoGProperties props) {
        super.get(props);
        String certH = this.certHandleTF.getText();
        String keyH = this.keyHandleTF.getText();
        if (certH.length() == 0) {
            certH = keyH.length() == 0 ? (keyH = props.getDefaultPKCS11Handle()) : keyH;
        } else if (keyH.length() == 0) {
            keyH = certH;
        }
        props.put("pkcs11.certhandle", certH);
        props.put("pkcs11.keyhandle", keyH);
    }
}

