/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.common.security.messages.impl;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.gcube.soa3.connector.common.security.Credentials;
import org.gcube.soa3.connector.common.security.messages.MessageManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapMessageManager
implements MessageManager {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private SOAPMessage message;

    public SoapMessageManager(SOAPMessage message) {
        this.message = message;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.log.debug("Setting credentials..");
        credentials.prepareCredentials();
        String headerString = credentials.getHeaderString();
        this.log.debug("Header string = " + headerString);
        if (headerString != null) {
            this.log.debug("Inserting credentials string into the header");
            try {
                this.log.debug("Inserting the header in the message");
                this.message.getSOAPHeader().addChildElement(this.generateBinaryTokenElement(credentials.getAuthenticationType(), headerString));
                this.log.debug("Header added");
            }
            catch (SOAPException e) {
                this.log.error("Unable to generate token security header", (Throwable)e);
            }
        } else {
            this.log.debug("No headers to be inserted in the message");
        }
    }

    private SOAPElement generateBinaryTokenElement(String type, String binaryTokenValue) throws SOAPException {
        this.log.debug("Generating token SOAP element");
        this.log.debug("Type = " + type);
        this.log.debug("Value = " + binaryTokenValue);
        SOAPFactory sf = SOAPFactory.newInstance();
        SOAPElement tokenElement = sf.createElement(new QName("http://schemas.xmlsoap.org/ws/2002/04/secext", "wsse:BinarySecurityToken"));
        tokenElement.setAttribute("ValueType", type);
        tokenElement.setAttribute("EncodingType", "wsse:Base64Binary");
        tokenElement.setAttribute("Id", "SecurityToken");
        tokenElement.setValue(binaryTokenValue);
        this.log.debug("Header completed");
        return tokenElement;
    }
}

