/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.GarbageCollector;

import com.sun.org.apache.xpath.internal.XPathAPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.gcube.common.searchservice.searchlibrary.GarbageCollector.GCProperties;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.HeaderRef;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementGC;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementLifeSpanGC;
import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementWSEPR;
import org.gcube.common.searchservice.searchlibrary.resultset.helpers.RSFileHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GCHelper {
    private static Logger log = Logger.getLogger(GCHelper.class);

    public static String goToLast(String filename, GCProperties props) {
        try {
            while (true) {
                String next = null;
                if (!GCHelper.isXML(filename)) {
                    HeaderRef head = RSFileHelper.populateHeader((String)filename);
                    next = head.getNext();
                } else {
                    DocumentBuilderFactory datadbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder datadb = datadbf.newDocumentBuilder();
                    Document dom = datadb.parse(new File(filename));
                    NodeList nextnl = dom.getElementsByTagName("Part");
                    for (int i = 0; i < nextnl.getLength(); ++i) {
                        if (!((Element)nextnl.item(i)).getAttribute("Name").equals("next")) continue;
                        next = ((Element)nextnl.item(i)).getFirstChild().getNodeValue();
                        break;
                    }
                }
                if (next.equalsIgnoreCase("no")) {
                    return filename;
                }
                filename = next;
                props.addToChain(filename);
                File exam = new File(filename);
                props.setLastAccessed(exam.lastModified());
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not go to Last. Returning current " + filename));
            return filename;
        }
    }

    public static String goToHead(String filename, GCProperties props) {
        try {
            while (true) {
                String prev = null;
                if (!GCHelper.isXML(filename)) {
                    HeaderRef head = RSFileHelper.populateHeader((String)filename);
                    prev = head.getPrev();
                } else {
                    DocumentBuilderFactory datadbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder datadb = datadbf.newDocumentBuilder();
                    Document dom = datadb.parse(new File(filename));
                    NodeList nextnl = dom.getElementsByTagName("Part");
                    for (int i = 0; i < nextnl.getLength(); ++i) {
                        if (!((Element)nextnl.item(i)).getAttribute("Name").equals("previous")) continue;
                        prev = ((Element)nextnl.item(i)).getFirstChild().getNodeValue();
                        break;
                    }
                }
                if (prev.equalsIgnoreCase("no")) {
                    return filename;
                }
                filename = prev;
                props.addToChain(filename);
                File exam = new File(filename);
                props.setLastAccessed(exam.lastModified());
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not go to Head. Returning current " + filename));
            return filename;
        }
    }

    public static void headPoperties(String filename, GCProperties props) {
        try {
            PropertyElementGC tmp;
            XMLSerializer serializer;
            StringWriter writer;
            OutputFormat format;
            Element rootEle;
            Document newdom;
            DocumentBuilder db;
            DocumentBuilderFactory bf;
            int i;
            NodeList res;
            File exam = new File(filename);
            props.setLastAccessed(exam.lastModified());
            DocumentBuilderFactory datadbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder datadb = datadbf.newDocumentBuilder();
            Document dom = datadb.parse(exam);
            try {
                res = XPathAPI.selectNodeList(dom, "/ResultSet/Head/CustomProperties/" + PropertyElementGC.propertyType);
                if (res != null) {
                    for (i = 0; i < res.getLength(); ++i) {
                        bf = DocumentBuilderFactory.newInstance();
                        db = bf.newDocumentBuilder();
                        newdom = db.newDocument();
                        rootEle = (Element)newdom.importNode(res.item(i).cloneNode(true), true);
                        newdom.appendChild(rootEle);
                        format = new OutputFormat(newdom);
                        format.setIndenting(false);
                        format.setOmitDocumentType(true);
                        format.setOmitXMLDeclaration(true);
                        writer = new StringWriter();
                        serializer = new XMLSerializer((Writer)writer, format);
                        serializer.serialize(newdom);
                        tmp = new PropertyElementGC();
                        tmp.RS_fromXML(writer.toString());
                        props.addSSID(tmp.toXML());
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)("Could not find " + PropertyElementGC.propertyType + " property...Continuing"), (Throwable)e);
            }
            try {
                res = XPathAPI.selectNodeList(dom, "/ResultSet/Head/CustomProperties/" + PropertyElementLifeSpanGC.propertyType);
                if (res != null) {
                    for (i = 0; i < res.getLength(); ++i) {
                        bf = DocumentBuilderFactory.newInstance();
                        db = bf.newDocumentBuilder();
                        newdom = db.newDocument();
                        rootEle = (Element)newdom.importNode(res.item(i).cloneNode(true), true);
                        newdom.appendChild(rootEle);
                        format = new OutputFormat(newdom);
                        format.setIndenting(false);
                        format.setOmitDocumentType(true);
                        format.setOmitXMLDeclaration(true);
                        writer = new StringWriter();
                        serializer = new XMLSerializer((Writer)writer, format);
                        serializer.serialize(newdom);
                        tmp = new PropertyElementLifeSpanGC();
                        tmp.RS_fromXML(writer.toString());
                        props.addLifeSpan(tmp.toXML());
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)("Could not find " + PropertyElementLifeSpanGC.propertyType + " property...Continuing"), (Throwable)e);
            }
            try {
                res = XPathAPI.selectNodeList(dom, "/ResultSet/Head/CustomProperties/" + PropertyElementWSEPR.propertyType);
                if (res != null) {
                    for (i = 0; i < res.getLength(); ++i) {
                        bf = DocumentBuilderFactory.newInstance();
                        db = bf.newDocumentBuilder();
                        newdom = db.newDocument();
                        rootEle = (Element)newdom.importNode(res.item(i).cloneNode(true), true);
                        newdom.appendChild(rootEle);
                        format = new OutputFormat(newdom);
                        format.setIndenting(false);
                        format.setOmitDocumentType(true);
                        format.setOmitXMLDeclaration(true);
                        writer = new StringWriter();
                        serializer = new XMLSerializer((Writer)writer, format);
                        serializer.serialize(newdom);
                        tmp = new PropertyElementWSEPR();
                        tmp.RS_fromXML(writer.toString());
                        props.addWSEPR(tmp.toXML());
                    }
                }
            }
            catch (Exception e) {
                log.debug((Object)("Could not find " + PropertyElementWSEPR.propertyType + " property...Continuing"), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error((Object)("Could not parse for head properties file " + filename), (Throwable)e);
        }
    }

    public static void tailPoperties(String filename, GCProperties props) {
        try {
            File exam = new File(filename);
            props.setLastAuthored(exam.lastModified());
            String next = null;
            if (GCHelper.isXML(filename)) {
                DocumentBuilderFactory datadbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder datadb = datadbf.newDocumentBuilder();
                Document dom = datadb.parse(new File(filename));
                NodeList nextnl = dom.getElementsByTagName("Part");
                for (int i = 0; i < nextnl.getLength(); ++i) {
                    if (!((Element)nextnl.item(i)).getAttribute("Name").equals("next")) continue;
                    next = ((Element)nextnl.item(i)).getFirstChild().getNodeValue();
                    break;
                }
            } else {
                HeaderRef head = RSFileHelper.populateHeader((String)filename);
                next = head.getNext();
            }
            if (next.equalsIgnoreCase("no")) {
                props.setComplete(true);
            } else {
                props.setComplete(true);
            }
        }
        catch (FileNotFoundException x) {
            log.error((Object)("File " + filename + " not found. Probably an RS is being written."));
        }
        catch (Exception e) {
            log.error((Object)("Could not parse for tail properties file " + filename));
            log.trace((Object)"Exception: ", (Throwable)e);
        }
    }

    private static boolean isXML(String filename) throws Exception {
        FileReader fr = new FileReader(new File(filename));
        BufferedReader br = new BufferedReader(fr);
        String line = br.readLine();
        if (line.trim().length() > 0) {
            br.close();
            fr.close();
            return line.trim().startsWith("<");
        }
        while (line != null) {
            line = br.readLine();
            if (line.trim().length() <= 0) continue;
            br.close();
            fr.close();
            return line.trim().startsWith("<");
        }
        br.close();
        fr.close();
        return false;
    }

    public static boolean alreadyChecked(String filename, MessageDigest algorithm, Set<String> checked) {
        if (filename.endsWith(".rs")) {
            return false;
        }
        algorithm.reset();
        algorithm.update(filename.getBytes());
        String key = new String(algorithm.digest());
        if (checked.contains(key)) {
            return true;
        }
        checked.add(key);
        return false;
    }
}

