/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.terracotta;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.util.PreferTCCLObjectInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RotatingSnapshotFile {
    private static final Logger LOG = LoggerFactory.getLogger(RotatingSnapshotFile.class);
    private static final String SUFFIX_OK = ".keySet";
    private static final String SUFFIX_PROGRESS = ".keySet.temp";
    private static final String SUFFIX_MOVE = ".keySet.old";
    private volatile boolean shutdownOnThreadInterrupted;
    private final File targetDirectory;
    private final String baseName;
    private final Lock readLock;
    private final Lock writeLock;

    RotatingSnapshotFile(String directory, String baseName) {
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readLock = rwl.readLock();
        this.writeLock = rwl.writeLock();
        this.baseName = baseName;
        this.targetDirectory = new File(directory);
        if (this.targetDirectory.exists() && !this.targetDirectory.isDirectory()) {
            throw new IllegalArgumentException("The specified target directory is not a directory: " + directory);
        }
        if (!this.targetDirectory.exists() && !this.targetDirectory.mkdirs()) {
            throw new RuntimeException("Couldn't create the target directory: " + directory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeAll(Iterable localKeys) throws IOException {
        this.writeLock.lock();
        long writtenKeys = 0L;
        try {
            File inProgress = this.newSnapshotFile();
            this.cleanUp(inProgress);
            if (!inProgress.createNewFile()) {
                throw new AssertionError((Object)("The file '" + inProgress.getAbsolutePath() + "' exists already!"));
            }
            FileOutputStream fileOutputStream = new FileOutputStream(inProgress);
            ObjectOutputStream oos = new ObjectOutputStream(fileOutputStream);
            try {
                for (Object localKey : localKeys) {
                    if (this.shutdownOnThreadInterrupted && Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    oos.writeObject(localKey);
                    ++writtenKeys;
                }
            }
            finally {
                fileOutputStream.close();
            }
            this.swapForOldWithNewSnapshot(inProgress);
        }
        finally {
            LOG.info("Did a snapshot of " + writtenKeys + " local keys");
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Set<T> readAll() throws IOException {
        this.cleanUp();
        this.readLock.lock();
        try {
            File currentSnapshot = this.currentSnapshotFile();
            if (!currentSnapshot.exists()) {
                Set set = Collections.emptySet();
                return set;
            }
            HashSet<Object> values = new HashSet<Object>();
            FileInputStream fis = new FileInputStream(currentSnapshot);
            try {
                PreferTCCLObjectInputStream ois = new PreferTCCLObjectInputStream(fis);
                boolean eof = false;
                while (!eof) {
                    try {
                        values.add(ois.readObject());
                    }
                    catch (Exception e) {
                        if (!(e instanceof EOFException)) continue;
                        eof = true;
                    }
                }
                try {
                    ois.close();
                }
                catch (IOException e) {
                    LOG.error("Error closing ObjectInputStream", (Throwable)e);
                    this.closeAndDeleteAssociatedFileOnFailure(fis, currentSnapshot);
                }
            }
            catch (IOException e) {
                this.closeAndDeleteAssociatedFileOnFailure(fis, currentSnapshot);
            }
            Set set = Collections.unmodifiableSet(values);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUp() {
        if (this.requiresCleanUp()) {
            this.writeLock.lock();
            try {
                this.cleanUp(this.newSnapshotFile());
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private void cleanUp(File inProgress) {
        if (this.requiresCleanUp()) {
            File dest = this.currentSnapshotFile();
            if (dest.exists() && !inProgress.delete()) {
                throw new RuntimeException("Couldn't cleanup old file " + inProgress.getAbsolutePath());
            }
            File tempFile = this.tempSnapshotFile();
            if (tempFile.exists() && !tempFile.delete()) {
                throw new RuntimeException("Couldn't cleanup temp file " + tempFile.getAbsolutePath());
            }
            if (inProgress.exists() && !inProgress.renameTo(dest)) {
                throw new RuntimeException("Couldn't rename new snapshot: " + dest.getAbsolutePath());
            }
        }
    }

    private boolean requiresCleanUp() {
        return this.newSnapshotFile().exists();
    }

    private void swapForOldWithNewSnapshot(File inProgress) {
        File currentSnapshot = this.currentSnapshotFile();
        File tempFile = this.tempSnapshotFile();
        if (currentSnapshot.exists() && !currentSnapshot.renameTo(tempFile)) {
            throw new RuntimeException("Couldn't rename previous snapshot: " + currentSnapshot.getAbsolutePath());
        }
        if (!inProgress.renameTo(currentSnapshot)) {
            throw new RuntimeException("Couldn't rename new snapshot: " + currentSnapshot.getAbsolutePath());
        }
        if (tempFile.exists() && !tempFile.delete()) {
            throw new RuntimeException("Couldn't delete temp file " + tempFile.getAbsolutePath());
        }
    }

    File currentSnapshotFile() {
        return new File(this.targetDirectory, this.baseName + SUFFIX_OK);
    }

    File newSnapshotFile() {
        return new File(this.targetDirectory, this.baseName + SUFFIX_PROGRESS);
    }

    File tempSnapshotFile() {
        return new File(this.targetDirectory, this.baseName + SUFFIX_MOVE);
    }

    void setShutdownOnThreadInterrupted(boolean shutdownOnThreadInterrupted) {
        this.shutdownOnThreadInterrupted = shutdownOnThreadInterrupted;
    }

    private void closeAndDeleteAssociatedFileOnFailure(FileInputStream fis, File associatedFile) {
        block2: {
            try {
                fis.close();
            }
            catch (IOException e) {
                LOG.error("Couldn't close FileInputStream on {}, deleting the file!", (Object)associatedFile.getAbsolutePath(), (Object)e);
                if (!associatedFile.exists() || associatedFile.delete()) break block2;
                LOG.error("Couldn't delete file {}", (Object)associatedFile.getAbsolutePath(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void snapshotNowOrWaitForCurrentToFinish(Set localKeys) throws IOException {
        if (this.writeLock.tryLock()) {
            try {
                this.writeAll(localKeys);
            }
            finally {
                this.writeLock.unlock();
            }
        } else {
            this.writeLock.lock();
            this.writeLock.unlock();
        }
    }
}

