/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.providers;

import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.providers.GSSKey;
import org.globus.wsrf.providers.GSSPrivateKey;
import org.globus.wsrf.providers.GSSPublicKey;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public class GSSSignature
extends SignatureSpi {
    private GSSContext context;
    private static Log logger = LogFactory.getLog((String)(class$org$globus$wsrf$providers$GSSSignature == null ? (class$org$globus$wsrf$providers$GSSSignature = GSSSignature.class$("org.globus.wsrf.providers.GSSSignature")) : class$org$globus$wsrf$providers$GSSSignature).getName());
    private byte[] plaintext = null;
    static /* synthetic */ Class class$org$globus$wsrf$providers$GSSSignature;

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof GSSPublicKey)) {
            throw new InvalidKeyException();
        }
        this.context = ((GSSKey)((Object)publicKey)).getContext();
        logger.debug((Object)"init called");
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof GSSPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.context = ((GSSKey)((Object)privateKey)).getContext();
        logger.debug((Object)"init called");
    }

    protected void engineUpdate(byte b) {
        if (this.plaintext == null) {
            this.plaintext = new byte[]{b};
        } else {
            byte[] tmp = new byte[this.plaintext.length + 1];
            System.arraycopy(this.plaintext, 0, tmp, 0, this.plaintext.length);
            tmp[this.plaintext.length] = b;
            this.plaintext = tmp;
        }
    }

    protected void engineUpdate(byte[] bytes, int offset, int length) {
        if (this.plaintext == null) {
            this.plaintext = new byte[length];
            System.arraycopy(bytes, offset, this.plaintext, 0, length);
        } else {
            byte[] tmp = new byte[this.plaintext.length + length];
            System.arraycopy(this.plaintext, 0, tmp, 0, this.plaintext.length);
            System.arraycopy(bytes, offset, tmp, this.plaintext.length, length);
            this.plaintext = tmp;
        }
    }

    protected byte[] engineSign() throws SignatureException {
        byte[] signature = null;
        if (this.plaintext == null) {
            throw new SignatureException("Nothing to sign");
        }
        try {
            signature = this.context.getMIC(this.plaintext, 0, this.plaintext.length, null);
        }
        catch (GSSException e) {
            logger.debug((Object)"", (Throwable)e);
            throw new SignatureException("Failed to sign");
        }
        this.plaintext = null;
        return signature;
    }

    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        if (this.plaintext == null) {
            throw new SignatureException("Nothing to verify");
        }
        try {
            this.context.verifyMIC(sigBytes, 0, sigBytes.length, this.plaintext, 0, this.plaintext.length, null);
        }
        catch (GSSException e) {
            logger.debug((Object)"", (Throwable)e);
            throw new SignatureException("Failed to verify");
        }
        return true;
    }

    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
    }

    protected Object engineGetParameter(String param) throws InvalidParameterException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

