/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.filter.DestinationPath;

public class PrefixDestinationFilter
extends DestinationFilter {
    private String[] prefixes;
    private byte destinationType;

    public PrefixDestinationFilter(String[] prefixes, byte destinationType) {
        this.prefixes = prefixes;
        this.destinationType = destinationType;
    }

    @Override
    public boolean matches(ActiveMQDestination destination) {
        int length;
        if (destination.getDestinationType() != this.destinationType) {
            return false;
        }
        String[] path = DestinationPath.getDestinationPaths(destination.getPhysicalName());
        if (path.length >= (length = this.prefixes.length)) {
            int size = length - 1;
            for (int i = 0; i < size; ++i) {
                if (path[i].equals("*") || this.prefixes[i].equals("*") || this.prefixes[i].equals(path[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getText() {
        return DestinationPath.toString(this.prefixes);
    }

    public String toString() {
        return super.toString() + "[destination: " + this.getText() + "]";
    }

    public boolean isWildcard() {
        return true;
    }
}

