/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.handlers;

import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.utils.Resources;

public class MessageLoggingHandler
extends BasicHandler {
    private static Log logger = LogFactory.getLog((String)MessageLoggingHandler.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());

    public void invoke(MessageContext messageContext) throws AxisFault {
        this.logMessage(messageContext.getCurrentMessage());
    }

    public void onFault(MessageContext messageContext) {
        if (messageContext.isClient()) {
            return;
        }
        this.logMessage(messageContext.getResponseMessage());
    }

    protected void logMessage(Message message) {
        if (logger.isDebugEnabled()) {
            if (message == null) {
                logger.debug((Object)"Empty SOAPEnvelope");
            } else {
                try {
                    SOAPEnvelope soapEnvelope = message.getSOAPEnvelope();
                    logger.debug((Object)("SOAPEnvelope: " + soapEnvelope));
                }
                catch (AxisFault af) {
                    logger.error((Object)i18n.getMessage("messageLoggingError"), (Throwable)af);
                }
            }
        }
    }
}

