/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.rmi.RemoteException;
import java.util.Collection;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.xml.soap.SOAPElement;
import org.apache.axis.encoding.AnyContentType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.Topic;
import org.globus.wsrf.TopicList;
import org.globus.wsrf.TopicListAccessor;
import org.globus.wsrf.encoding.ObjectConverter;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.jndi.JNDIUtils;
import org.globus.wsrf.topicexpression.UnsupportedTopicExpressionDialectException;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsn.GetCurrentMessage;
import org.oasis.wsn.GetCurrentMessageResponse;
import org.oasis.wsn.InvalidTopicExpressionFaultType;
import org.oasis.wsn.NoCurrentMessageOnTopicFaultType;
import org.oasis.wsn.ResourceUnknownFaultType;
import org.oasis.wsn.TopicNotSupportedFaultType;
import org.oasis.wsn.TopicPathDialectUnknownFaultType;
import org.oasis.wsrf.faults.BaseFaultType;

public class GetCurrentMessageProvider {
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    private static Log logger = LogFactory.getLog((String)GetCurrentMessageProvider.class.getName());
    private static String GET_CURRENT_MESSAGE_CONTEXT = "java:comp/env//providers/GetCurrentMessageProvider/";

    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage request) throws RemoteException, ResourceUnknownFaultType, InvalidTopicExpressionFaultType, TopicNotSupportedFaultType, NoCurrentMessageOnTopicFaultType {
        Collection topics;
        Resource resource = null;
        try {
            resource = ResourceContext.getResourceContext().getResource();
        }
        catch (NoSuchResourceException e) {
            ResourceUnknownFaultType fault = new ResourceUnknownFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.setDescription(i18n.getMessage("resourceDisoveryFailed"));
            faultHelper.addFaultCause(e);
            throw fault;
        }
        catch (Exception e) {
            throw new RemoteException(i18n.getMessage("resourceDisoveryFailed"), e);
        }
        if (!(resource instanceof TopicListAccessor)) {
            throw new TopicNotSupportedFaultType();
        }
        TopicList topicList = ((TopicListAccessor)((Object)resource)).getTopicList();
        try {
            topics = topicList.getTopics(request.getTopic());
        }
        catch (UnsupportedTopicExpressionDialectException e) {
            logger.debug((Object)"", (Throwable)((Object)e));
            TopicPathDialectUnknownFaultType fault = new TopicPathDialectUnknownFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause((Throwable)((Object)e));
            throw fault;
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            InvalidTopicExpressionFaultType fault = new InvalidTopicExpressionFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause(e);
            faultHelper.setDescription(i18n.getMessage("topicExpressionResolutionFailed"));
            throw fault;
        }
        if (topics.isEmpty()) {
            throw new TopicNotSupportedFaultType();
        }
        Object message = ((Topic)topics.toArray()[0]).getCurrentMessage();
        if (message == null) {
            throw new NoCurrentMessageOnTopicFaultType();
        }
        ObjectConverter converter = null;
        try {
            InitialContext initialContext = new InitialContext();
            converter = (ObjectConverter)JNDIUtils.lookup(initialContext, GET_CURRENT_MESSAGE_CONTEXT + message.getClass().getName(), ObjectConverter.class);
        }
        catch (NameNotFoundException e) {
        }
        catch (Exception e) {
            logger.debug((Object)"Converter lookup failed", (Throwable)e);
        }
        GetCurrentMessageResponse response = new GetCurrentMessageResponse();
        try {
            SOAPElement elem = converter != null ? converter.toSOAPElement(message) : ObjectSerializer.toSOAPElement(message);
            AnyHelper.setAny((AnyContentType)response, elem);
        }
        catch (Exception e) {
            throw new RemoteException(i18n.getMessage("notificationSerializationError"), e);
        }
        return response;
    }
}

