/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication;

import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.auth.HostAuthorization;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.gsi.gssapi.auth.NoAuthorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.wsrf.config.ConfigException;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityConfig;
import org.globus.wsrf.impl.security.descriptor.ClientSecurityDescriptor;

public class ClientPropertiesHandler
extends BasicHandler {
    private static Log logger = LogFactory.getLog((String)ClientPropertiesHandler.class.getName());

    public void invoke(MessageContext msgCtx) throws AxisFault {
        String descFileName = (String)msgCtx.getProperty("clientDescriptorFile");
        logger.debug((Object)("Descriptor file name " + descFileName));
        ClientSecurityDescriptor desc = null;
        if (descFileName == null) {
            desc = (ClientSecurityDescriptor)msgCtx.getProperty("clientDescriptor");
        } else {
            try {
                desc = ClientSecurityConfig.initialize(descFileName);
            }
            catch (ConfigException exp) {
                throw AxisFault.makeFault((Exception)((Object)exp));
            }
        }
        if (desc == null) {
            logger.debug((Object)"Descriptor is null");
            return;
        }
        Authorization authz = desc.getAuthz();
        HostAuthorization gsiAuthz = null;
        msgCtx.setProperty("org.globus.security.authorization", (Object)authz);
        if (authz instanceof org.globus.wsrf.impl.security.authorization.HostAuthorization) {
            gsiAuthz = HostAuthorization.getInstance();
        } else if (authz instanceof org.globus.wsrf.impl.security.authorization.NoAuthorization) {
            gsiAuthz = NoAuthorization.getInstance();
        } else if (authz instanceof org.globus.wsrf.impl.security.authorization.SelfAuthorization) {
            gsiAuthz = SelfAuthorization.getInstance();
        } else if (authz instanceof org.globus.wsrf.impl.security.authorization.IdentityAuthorization) {
            gsiAuthz = new IdentityAuthorization(((org.globus.wsrf.impl.security.authorization.IdentityAuthorization)authz).getIdentity());
        }
        msgCtx.setProperty("org.globus.gsi.authorization", (Object)gsiAuthz);
        msgCtx.setProperty("org.globus.security.secConv.msg.type", (Object)desc.getGSISecureConv());
        logger.debug((Object)("Secure conv " + desc.getGSISecureConv()));
        msgCtx.setProperty("org.globus.gsi.anonymous", (Object)desc.getAnonymous());
        msgCtx.setProperty("org.globus.gsi.mode", (Object)desc.getDelegation());
        msgCtx.setProperty("org.globus.gsi.credentials", (Object)desc.getGSSCredential());
        msgCtx.setProperty("org.globus.security.secMsg.msg.type", (Object)desc.getGSISecureMsg());
        logger.debug((Object)("Secure msg " + desc.getGSISecureMsg()));
        msgCtx.setProperty("callerSubject", (Object)desc.getPeerSubject());
        msgCtx.setProperty("org.globus.security.transport.type", (Object)desc.getGSITransport());
    }
}

