/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.encryption;

import javax.crypto.SecretKey;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.message.WSEncryptBody;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.globus.wsrf.impl.security.authentication.ContextCrypto;
import org.globus.wsrf.impl.security.authentication.secureconv.SecureConversationMessage;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.globus.wsrf.impl.security.util.EnvelopeConverter;
import org.globus.wsrf.providers.GSSKey;
import org.ietf.jgss.GSSContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GssEncryptedSOAPEnvelopeBuilder
extends WSEncryptBody {
    public static final String ALGORITHM = "http://www.globus.org/2002/04/xmlenc#gssapi-enc";
    private static Log logger;
    protected GSSContext context;
    protected String contextId;
    protected MessageContext msgContext;
    protected static ContextCrypto crypto;

    public GssEncryptedSOAPEnvelopeBuilder(MessageContext msgContext, SecurityContext context) {
        this(msgContext, context.getContext(), (String)context.getID());
    }

    protected GssEncryptedSOAPEnvelopeBuilder(MessageContext msgContext, GSSContext context, String contextId) {
        this.context = context;
        this.contextId = contextId;
        this.msgContext = msgContext;
        this.setSymmetricEncAlgorithm(ALGORITHM);
        this.setSymmetricKey((SecretKey)new GSSKey(contextId, context));
    }

    private String getContextId() {
        if (this.contextId == null) {
            return String.valueOf(this.context.hashCode());
        }
        return this.contextId;
    }

    public SOAPEnvelope build(SOAPEnvelope envelope) throws Exception {
        return this.buildMessage(envelope).getSOAPPart().getEnvelope();
    }

    public SOAPMessage buildMessage(SOAPEnvelope env) throws Exception {
        logger.debug((Object)"Beginning encryption...");
        Document doc = EnvelopeConverter.getInstance().toDocument(env);
        WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
        SecurityTokenReference securityTokenReference = new SecurityTokenReference(wssConfig, doc);
        Reference tokenReference = new Reference(wssConfig, doc);
        tokenReference.setValueType(SecureConversationMessage.CONTEXT_TOKEN_VALUE_TYPE.toString());
        tokenReference.setURI("#SecurityContextToken-" + env.hashCode());
        securityTokenReference.setReference(tokenReference);
        this.setSecurityTokenReference(securityTokenReference);
        this.setKey(new byte[1]);
        this.setKeyIdentifierType(6);
        doc = this.build(doc, crypto);
        SecurityContextToken secContextToken = new SecurityContextToken(doc, this.getContextId());
        secContextToken.setID("SecurityContextToken-" + env.hashCode());
        Element secHeader = this.insertSecurityHeader(doc);
        WSSecurityUtil.prependChildElement((Document)doc, (Element)secHeader, (Element)secContextToken.getElement(), (boolean)false);
        SOAPMessage message = EnvelopeConverter.getInstance().toSOAPMessage(doc);
        logger.debug((Object)"Encryption complete");
        return message;
    }

    static {
        GSSConfig.init();
        logger = LogFactory.getLog((String)GssEncryptedSOAPEnvelopeBuilder.class.getName());
        crypto = ContextCrypto.getInstance();
    }
}

