/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.securemsg;

import [Ljava.security.cert.X509Certificate;;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authentication.encryption.EncryptionCredentials;
import org.globus.wsrf.impl.security.authentication.encryption.X509WSEncryptedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityException;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;

public class X509EncryptHandler
extends GenericHandler {
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authentication.errors");
    private static Log log = LogFactory.getLog((String)X509EncryptHandler.class.getName());

    public boolean handleRequest(MessageContext context) {
        Iterator iterator;
        if (!this.encryptionRequested((SOAPMessageContext)context)) {
            return false;
        }
        X509Certificate serverCert = null;
        Subject peerSubject = (Subject)context.getProperty("callerSubject");
        if (peerSubject == null) {
            throw WSSecurityFault.makeFault(new WSSecurityException(0, "noEncCreds"));
        }
        Set encryptCredSet = peerSubject.getPublicCredentials(EncryptionCredentials.class);
        if (encryptCredSet != null && (iterator = encryptCredSet.iterator()).hasNext()) {
            EncryptionCredentials creds = (EncryptionCredentials)iterator.next();
            serverCert = creds.getFirstCertificate();
        }
        if (serverCert == null) {
            throw WSSecurityFault.makeFault(new WSSecurityException(0, "noEncCreds"));
        }
        return this.handleMessage((SOAPMessageContext)context, serverCert);
    }

    public boolean handleResponse(MessageContext context) {
        if (!this.encryptionRequested((SOAPMessageContext)context)) {
            return false;
        }
        Subject subject = (Subject)context.getProperty("callerSubject");
        X509Certificate clientCert = null;
        if (subject == null) {
            log.error((Object)i18n.getMessage("noEncCreds"));
            throw WSSecurityFault.makeFault(new WSSecurityException(0, "noEncCreds"));
        }
        clientCert = this.getPublicCredential(subject);
        log.debug((Object)("Client " + clientCert.getSubjectDN().getName()));
        return this.handleMessage((SOAPMessageContext)context, clientCert);
    }

    public boolean handleMessage(SOAPMessageContext ctx, X509Certificate clientCert) {
        SOAPMessage msg;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Enter: encrypt " + clientCert.getPublicKey().getEncoded().length));
        }
        if ((msg = ctx.getMessage()) == null) {
            log.debug((Object)"No message - not encrypting.");
            return true;
        }
        SOAPMessage encryptedMsg = null;
        try {
            SOAPEnvelope unsignedEnvelope = msg.getSOAPPart().getEnvelope();
            X509WSEncryptedSOAPEnvelopeBuilder builder = new X509WSEncryptedSOAPEnvelopeBuilder(clientCert);
            builder.setActor((String)ctx.getProperty("x509Actor"));
            encryptedMsg = builder.buildMessage(unsignedEnvelope);
        }
        catch (Exception e) {
            log.error((Object)i18n.getMessage("encryptErr"), (Throwable)e);
            throw WSSecurityFault.makeFault(e);
        }
        ctx.setMessage(encryptedMsg);
        log.debug((Object)"Exit: encrypt");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }

    private X509Certificate getPublicCredential(Subject subject) {
        X509Certificate[] cert;
        Iterator iter;
        if (subject == null) {
            return null;
        }
        Set gssCreds = subject.getPublicCredentials(X509Certificate;.class);
        if (gssCreds != null && (iter = gssCreds.iterator()).hasNext() && (cert = (X509Certificate[])iter.next()) != null && cert.length > 0) {
            return cert[0];
        }
        return null;
    }

    private boolean encryptionRequested(SOAPMessageContext ctx) {
        Object tmp = ctx.getProperty("org.globus.security.secMsg.msg.type");
        return Constants.ENCRYPTION.equals(tmp);
    }
}

