/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.state.store.registry;

import gr.uoa.di.madgik.commons.configuration.ConfigurationManager;
import java.io.DataInputStream;
import java.io.RandomAccessFile;

public class StateStoreRegistryKey {
    private String Key = null;
    private long StartingDataOffset = 0L;
    private long EndingDataOffset = 0L;
    private long StartingRegistryOffset = 0L;
    private boolean Active = true;
    private EntryType TypeOfEntry = EntryType.Alphanumeric;

    public StateStoreRegistryKey() {
    }

    public StateStoreRegistryKey(String Key, long StartingDataOffset, long EndingDataOffset, long StartingRegistryOffset, EntryType TypeOfEntry) {
        this.Key = Key;
        this.StartingDataOffset = StartingDataOffset;
        this.EndingDataOffset = EndingDataOffset;
        this.StartingRegistryOffset = StartingRegistryOffset;
        this.TypeOfEntry = TypeOfEntry;
    }

    public Boolean IsActive() {
        return this.Active;
    }

    public void Deactivate() {
        this.Active = false;
    }

    public String GetKey() {
        return this.Key;
    }

    public EntryType GetTypeOfEntry() {
        return this.TypeOfEntry;
    }

    public long GetStartingRegistryOffset() {
        return this.StartingRegistryOffset;
    }

    public void SetStartingRegistryOffset(long Offset) {
        this.StartingRegistryOffset = Offset;
    }

    public long GetStartingDataOffset() {
        return this.StartingDataOffset;
    }

    public void SetStartingDataOffset(long Offset) {
        this.StartingDataOffset = Offset;
    }

    public long GetEndingDataOffset() {
        return this.EndingDataOffset;
    }

    public void SetEndingDataOffset(long Offset) {
        this.EndingDataOffset = Offset;
    }

    public void Encode(RandomAccessFile stream) throws Exception {
        this.StartingRegistryOffset = stream.getFilePointer();
        byte[] keybytes = this.Key.getBytes(ConfigurationManager.GetStringParameter("EncodingCharset"));
        stream.writeInt(keybytes.length);
        stream.write(keybytes);
        stream.writeLong(this.StartingDataOffset);
        stream.writeLong(this.EndingDataOffset);
        stream.writeLong(this.StartingRegistryOffset);
        stream.writeBoolean(this.Active);
        stream.writeInt(this.TypeOfEntry.ordinal());
    }

    public void Decode(DataInputStream stream) throws Exception {
        int sizeofkey = stream.readInt();
        byte[] keybytes = new byte[sizeofkey];
        stream.readFully(keybytes);
        this.Key = new String(keybytes, ConfigurationManager.GetStringParameter("EncodingCharset"));
        this.StartingDataOffset = stream.readLong();
        this.EndingDataOffset = stream.readLong();
        this.StartingRegistryOffset = stream.readLong();
        this.Active = stream.readBoolean();
        this.TypeOfEntry = EntryType.values()[stream.readInt()];
    }

    public static enum EntryType {
        Alphanumeric,
        File,
        Bytearray,
        Serializable,
        ISerializable;

    }
}

