/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.reader.decorators.keepalive;

import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderInvalidArgumentException;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.reader.decorators.RecordReaderDelegate;
import gr.uoa.di.madgik.grs.reader.decorators.keepalive.KeepAliveHandler;
import gr.uoa.di.madgik.grs.record.Record;
import java.util.concurrent.TimeUnit;

public class KeepAliveReader<T extends Record>
extends RecordReaderDelegate<T> {
    private KeepAliveHandler<T> handler = null;
    private Object synch = new Object();

    public KeepAliveReader(IRecordReader<T> reader, long keepAliveFrequency, TimeUnit keepAliveFrequencyUnit) throws GRS2ReaderInvalidArgumentException {
        super(reader);
        this.handler = new KeepAliveHandler<T>(reader, keepAliveFrequency, keepAliveFrequencyUnit, this.synch);
        Thread handlerThread = new Thread(this.handler);
        handlerThread.setDaemon(true);
        handlerThread.start();
    }

    public KeepAliveReader(IRecordReader<T> reader, long keepAliveFrequency, TimeUnit keepAliveFrequencyUnit, long inactivityTimeout, TimeUnit inactivityTimeUnit) throws GRS2ReaderInvalidArgumentException {
        super(reader);
        this.handler = new KeepAliveHandler<T>(reader, keepAliveFrequency, keepAliveFrequencyUnit, inactivityTimeout, inactivityTimeUnit, this.synch);
        Thread handlerThread = new Thread(this.handler);
        handlerThread.setDaemon(true);
        handlerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws GRS2ReaderException {
        Object object = this.synch;
        synchronized (object) {
            if (this.handler.getAvailableRecords() > 0) {
                return this.handler.get();
            }
            return super.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws GRS2ReaderException {
        Object object = this.synch;
        synchronized (object) {
            if (this.handler.getAvailableRecords() > 0) {
                return this.handler.get();
            }
            return super.get(timeout, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seek(long len) throws GRS2ReaderException {
        Object object = this.synch;
        synchronized (object) {
            int availableRecords = this.handler.getAvailableRecords();
            if (len > 0L) {
                if (len >= (long)availableRecords) {
                    this.handler.clear();
                    return super.seek(len - (long)availableRecords);
                }
                int i = 0;
                while ((long)i < len) {
                    this.handler.get();
                    ++i;
                }
                return len;
            }
            this.handler.clear();
            return super.seek(len - (long)availableRecords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long currentRecord() throws GRS2ReaderException {
        Object object = this.synch;
        synchronized (object) {
            return super.currentRecord() - (long)this.handler.getAvailableRecords();
        }
    }
}

