/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.record.field.mediation;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordMediationException;
import gr.uoa.di.madgik.grs.record.field.Field;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class MediatingInputStream
extends InputStream {
    private InputStream in = null;
    private Field field = null;

    protected MediatingInputStream(Field field) throws IOException, GRS2RecordMediationException {
        if (field == null) {
            throw new GRS2RecordMediationException("Provided field cannot be null");
        }
        this.field = field;
        this.in = this.field.getInputStream();
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        try {
            this.mediate(1);
        }
        catch (GRS2Exception e) {
            throw this.transformException(e);
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            this.mediate(b.length);
        }
        catch (GRS2Exception e) {
            throw this.transformException(e);
        }
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            this.mediate(len);
        }
        catch (GRS2Exception e) {
            throw this.transformException(e);
        }
        return this.in.read(b, off, len);
    }

    @Override
    public void reset() throws IOException {
        this.in.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    private void mediate(int needed) throws GRS2RecordDefinitionException, GRS2BufferException, GRS2ProxyMirrorException, IOException {
        while (needed > this.in.available() && !this.field.isAvailable()) {
            this.field.makeAvailable(IBuffer.TransportOverride.Defined);
        }
    }

    private IOException transformException(Exception ex) {
        StringBuilder buf = new StringBuilder();
        buf.append(ex.getMessage());
        buf.append("\n");
        StringWriter w = new StringWriter();
        ex.printStackTrace(new PrintWriter(w));
        buf.append(w.toString());
        return new IOException(buf.toString());
    }
}

