/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class CondVar {
    protected final Sync mutex_;

    public CondVar(Sync sync) {
        this.mutex_ = sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void await() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.mutex_.release();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
        finally {
            boolean bl = false;
            while (true) {
                try {
                    this.mutex_.acquire();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    continue;
                }
                break;
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean timedwait(long l) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        boolean bl = false;
        try {
            CondVar condVar = this;
            synchronized (condVar) {
                this.mutex_.release();
                try {
                    if (l > 0L) {
                        long l2 = System.currentTimeMillis();
                        this.wait(l);
                        bl = System.currentTimeMillis() - l2 <= l;
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.notify();
                    throw interruptedException;
                }
            }
        }
        finally {
            boolean bl2 = false;
            while (true) {
                try {
                    this.mutex_.acquire();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    continue;
                }
                break;
            }
            if (bl2) {
                Thread.currentThread().interrupt();
            }
        }
        return bl;
    }

    public synchronized void signal() {
        this.notify();
    }

    public synchronized void broadcast() {
        this.notifyAll();
    }
}

