/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.typedefs.TimeUnit;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;

public class Limit
extends Task
implements TaskContainer {
    private Vector tasks = new Vector();
    private long maxwait = 180L;
    protected TimeUnit unit = TimeUnit.SECOND_UNIT;
    private String timeoutProperty = null;
    private String timeoutValue = "true";
    private Task currentTask = null;
    private Thread taskRunner = null;
    private boolean failOnError = false;
    private Exception exception = null;

    public void addTask(Task task) throws BuildException {
        this.tasks.addElement(task);
    }

    public void setMaxwait(int wait) {
        this.maxwait = wait;
    }

    public void setUnit(String unit) {
        if (unit == null) {
            return;
        }
        if (unit.equals("second")) {
            this.setMaxWaitUnit(TimeUnit.SECOND_UNIT);
            return;
        }
        if (unit.equals("millisecond")) {
            this.setMaxWaitUnit(TimeUnit.MILLISECOND_UNIT);
            return;
        }
        if (unit.equals("minute")) {
            this.setMaxWaitUnit(TimeUnit.MINUTE_UNIT);
            return;
        }
        if (unit.equals("hour")) {
            this.setMaxWaitUnit(TimeUnit.HOUR_UNIT);
            return;
        }
        if (unit.equals("day")) {
            this.setMaxWaitUnit(TimeUnit.DAY_UNIT);
            return;
        }
        if (unit.equals("week")) {
            this.setMaxWaitUnit(TimeUnit.WEEK_UNIT);
            return;
        }
    }

    public void setMilliseconds(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.MILLISECOND_UNIT);
    }

    public void setSeconds(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.SECOND_UNIT);
    }

    public void setMinutes(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.MINUTE_UNIT);
    }

    public void setHours(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.HOUR_UNIT);
    }

    public void setDays(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.DAY_UNIT);
    }

    public void setWeeks(int value) {
        this.setMaxwait(value);
        this.setMaxWaitUnit(TimeUnit.WEEK_UNIT);
    }

    public void setMaxWaitUnit(TimeUnit unit) {
        this.unit = unit;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setProperty(String p) {
        this.timeoutProperty = p;
    }

    public void setValue(String v) {
        this.timeoutValue = v;
    }

    public void execute() throws BuildException {
        try {
            Thread runner;
            this.taskRunner = runner = new Thread(){

                public void run() {
                    Enumeration e = Limit.this.tasks.elements();
                    while (e.hasMoreElements() && Limit.this.taskRunner == this) {
                        Limit.this.currentTask = (Task)e.nextElement();
                        try {
                            Limit.this.currentTask.perform();
                        }
                        catch (Exception ex) {
                            if (Limit.this.failOnError) {
                                Limit.this.exception = ex;
                                return;
                            }
                            Limit.this.exception = ex;
                        }
                    }
                }
            };
            runner.start();
            runner.join(this.unit.toMillis(this.maxwait));
            if (runner.isAlive()) {
                this.taskRunner = null;
                runner.interrupt();
                int index = this.tasks.indexOf(this.currentTask);
                StringBuffer not_ran = new StringBuffer();
                for (int i = index + 1; i < this.tasks.size(); ++i) {
                    not_ran.append('<').append(((Task)this.tasks.get(i)).getTaskName()).append('>');
                    if (i >= this.tasks.size() - 1) continue;
                    not_ran.append(", ");
                }
                if (this.timeoutProperty != null) {
                    this.getProject().setNewProperty(this.timeoutProperty, this.timeoutValue);
                }
                StringBuffer msg = new StringBuffer();
                msg.append("Interrupted task <").append(this.currentTask.getTaskName()).append(">. Waited ").append(this.maxwait).append(" ").append(this.unit.getValue()).append(", but this task did not complete.").append(not_ran.length() > 0 ? " The following tasks did not execute: " + not_ran.toString() + "." : "");
                if (this.failOnError) {
                    throw new BuildException(msg.toString());
                }
                this.log(msg.toString());
            } else if (this.failOnError && this.exception != null) {
                throw new BuildException(this.exception);
            }
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }
}

