/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust.message.token;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class LifeTime {
    public Element element;
    public Element created;
    public Element expires;
    public static final QName TOKEN = new QName("http://schemas.xmlsoap.org/ws/2004/04/trust", "Lifetime", "wst");

    public LifeTime(Document doc, String created, String expires) {
        this.element = doc.createElementNS(TOKEN.getNamespaceURI(), "wst:" + TOKEN.getLocalPart());
        this.created = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "wst:Created");
        this.expires = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "wst:Expires");
        this.created.appendChild(doc.createTextNode(created));
        this.expires.appendChild(doc.createTextNode(expires));
        this.element.appendChild(this.created);
        this.element.appendChild(this.expires);
    }

    public LifeTime(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN)) {
            throw new WSSecurityException(4, "badTokenType00", new Object[]{el});
        }
        this.created = (Element)WSSecurityUtil.getDirectChild(elem, "Created", "http://schemas.xmlsoap.org/ws/2004/04/trust");
        this.expires = (Element)WSSecurityUtil.getDirectChild(elem, "Expires", "http://schemas.xmlsoap.org/ws/2004/04/trust");
    }

    public LifeTime(Document doc, int duration) {
        SimpleDateFormat sdtf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdtf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar rightNow = Calendar.getInstance();
        Calendar expires = Calendar.getInstance();
        this.element = doc.createElementNS(TOKEN.getNamespaceURI(), "wst:" + TOKEN.getLocalPart());
        WSSecurityUtil.setNamespace(this.element, TOKEN.getNamespaceURI(), "wst");
        this.created = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "wst:Created");
        WSSecurityUtil.setNamespace(this.created, TOKEN.getNamespaceURI(), "wst");
        this.expires = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "wst:Expires");
        WSSecurityUtil.setNamespace(this.expires, TOKEN.getNamespaceURI(), "wst");
        this.created.appendChild(doc.createTextNode(sdtf.format(rightNow.getTime())));
        long exp = rightNow.getTimeInMillis() + (long)(duration * 1000 * 60);
        expires.setTimeInMillis(exp);
        this.expires.appendChild(doc.createTextNode(sdtf.format(expires.getTime())));
        this.element.appendChild(this.created);
        this.element.appendChild(this.expires);
    }

    public Element getCreated() {
        return this.created;
    }

    public Element getElement() {
        return this.element;
    }

    public Element getExpires() {
        return this.expires;
    }

    public void setCreated(Element element) {
        this.created = element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setExpires(Element element) {
        this.expires = element;
    }
}

