/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.trust2;

import java.net.URI;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.utils.XMLUtils;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.message.token.UsernameToken;
import org.apache.ws.security.trust2.RequestSecurityToken;
import org.apache.ws.security.trust2.SecurityTokenOrReference;
import org.apache.ws.security.trust2.TokenTypes;
import org.apache.ws.security.trust2.TrustConstants;
import org.apache.ws.security.trust2.exception.NoRequestType;
import org.apache.ws.security.trust2.exception.NoSoapBody;
import org.apache.ws.security.trust2.exception.TrustException;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WSAddTokenRequest {
    private URI action = null;
    private RequestSecurityToken tokenRequest;

    public WSAddTokenRequest(RequestSecurityToken tokenRequest) {
        this.tokenRequest = tokenRequest;
    }

    public void addAction() throws NoRequestType {
        this.action = TrustConstants.getActionRequest(this.tokenRequest.getRequestType());
        if (this.action == null) {
            throw new NoRequestType("Cannot generate standard action element, no requestType specified.");
        }
    }

    public void addAction(URI action) {
        this.action = action;
    }

    public Document build(Document doc) throws DOMException, TrustException {
        Element soapBody;
        SOAPConstants soapConsts = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
        if (this.action != null) {
            Element envelope = doc.getDocumentElement();
            Element soapHeader = (Element)WSSecurityUtil.getDirectChild(doc.getFirstChild(), soapConsts.getHeaderQName().getLocalPart(), soapConsts.getEnvelopeURI());
            if (soapHeader == null) {
                soapHeader = WSAddTokenRequest.createElementInSameNamespace(envelope, soapConsts.getHeaderQName().getLocalPart());
                soapHeader = WSSecurityUtil.prependChildElement(doc, envelope, soapHeader, true);
            }
            Element actionElement = doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/03/addressing", "wst:Action");
            Text actionContent = doc.createTextNode(this.action.toString());
            actionElement.appendChild(actionContent);
            soapHeader.appendChild(actionElement);
        }
        if ((soapBody = WSSecurityUtil.findBodyElement(doc, soapConsts)) == null) {
            throw new NoSoapBody("A SOAP Body element is needed to insert the <RequestSecurityToken>.");
        }
        this.setWsuId(soapBody);
        if (this.tokenRequest != null) {
            soapBody.appendChild(this.tokenRequest.getElement());
        }
        return doc;
    }

    private static Element createElementInSameNamespace(Element parent, String localName) {
        String prefix = parent.getPrefix();
        if (prefix == null) {
            prefix = "";
        }
        String qName = prefix + ":" + localName;
        String nsUri = parent.getNamespaceURI();
        return parent.getOwnerDocument().createElementNS(nsUri, qName);
    }

    private String setWsuId(Element bodyElement) {
        String id = bodyElement.getAttributeNS(WSConstants.WSU_NS, "Id");
        if (id == null || id.length() == 0) {
            id = "id-" + Integer.toString(bodyElement.hashCode());
            String prefix = WSSecurityUtil.setNamespace(bodyElement, WSConstants.WSU_NS, "wsu");
            bodyElement.setAttributeNS(WSConstants.WSU_NS, prefix + ":Id", id);
        }
        return id;
    }

    public static void main(String[] args) throws Exception {
        SOAPEnvelope env = new SOAPEnvelope();
        Document doc = env.getAsDocument();
        WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
        RequestSecurityToken tokenRequest = new RequestSecurityToken(doc, TrustConstants.REQUEST_ISSUE);
        tokenRequest.setContext(new URI("http://context.context"));
        tokenRequest.setTokenType(TokenTypes.X509);
        UsernameToken userToken = new UsernameToken(wssConfig, doc);
        userToken.setName("bob");
        userToken.setPassword("bobspass");
        tokenRequest.setBase(new SecurityTokenOrReference(userToken));
        UsernameToken user2Token = new UsernameToken(wssConfig, doc);
        user2Token.setName("joe");
        user2Token.setPassword("bobspass");
        tokenRequest.addSupporting(new SecurityTokenOrReference(user2Token));
        UsernameToken user3Token = new UsernameToken(wssConfig, doc);
        user3Token.setName("mike");
        user3Token.setPassword("bobspass");
        tokenRequest.addSupporting(new SecurityTokenOrReference(user3Token));
        WSAddTokenRequest builder = new WSAddTokenRequest(tokenRequest);
        builder.addAction();
        doc = builder.build(doc);
        System.out.println("\n============= Request ==============");
        System.out.println(XMLUtils.DocumentToString(doc));
    }
}

