/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.ptls;

import COM.claymoresystems.cert.X509RSAPrivateKey;
import COM.claymoresystems.ptls.SSLContext;
import COM.claymoresystems.ptls.SSLSessionData;
import cryptix.provider.rsa.RawRSAPrivateKey;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Vector;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.globus.common.ChainedGeneralSecurityException;
import org.globus.gsi.GlobusCredential;
import xjava.security.interfaces.CryptixRSAPrivateKey;

public class PureTLSContext
extends SSLContext {
    static void init() {
    }

    public void setTrustedCertificates(X509Certificate[] certs) throws GeneralSecurityException {
        Vector<byte[]> list = this.getRootList();
        if (list == null) {
            list = new Vector<byte[]>();
            this.setRootList(list);
        }
        list.clear();
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                list.addElement(certs[i].getEncoded());
            }
        }
    }

    public void setCredential(GlobusCredential cred) throws GeneralSecurityException {
        X509Certificate[] certs = cred.getCertificateChain();
        Vector<byte[]> v = new Vector<byte[]>(certs.length);
        for (int i = certs.length - 1; i >= 0; --i) {
            v.addElement(certs[i].getEncoded());
        }
        this.setCertificateChain(v);
        this.setPrivateKey(PureTLSContext.convertPrivateKey(cred.getPrivateKey()));
        try {
            this.setPublicKeyFromCert(certs[0].getEncoded());
        }
        catch (IOException e) {
            throw new ChainedGeneralSecurityException("", e);
        }
    }

    private static PrivateKey convertPrivateKey(PrivateKey key) {
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaKey = (RSAPrivateCrtKey)key;
            RawRSAPrivateKey ck = new RawRSAPrivateKey(rsaKey.getPrivateExponent(), rsaKey.getPrimeP(), rsaKey.getPrimeQ(), rsaKey.getCrtCoefficient());
            return new X509RSAPrivateKey((CryptixRSAPrivateKey)ck);
        }
        throw new IllegalArgumentException();
    }

    protected synchronized SSLSessionData findSession(String key) {
        return null;
    }

    protected synchronized void storeSession(String key, SSLSessionData sd) {
    }

    static {
        Security.removeProvider("BC");
        Security.addProvider(new BouncyCastleProvider());
    }
}

