/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.secureconv;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.encryption.GssEncryptedSOAPEnvelopeBuilder;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;

public class EncryptHandler
extends GenericHandler {
    protected static I18n i18n = I18n.getI18n("org.globus.wsrf.impl.security.authentication.errors");
    private static Log log = LogFactory.getLog(EncryptHandler.class.getName());

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        SecurityContext secContext = (SecurityContext)ctx.getProperty("org.globus.security.secureconv.context");
        if (secContext == null) {
            log.debug("No context - not encrypting.");
            return true;
        }
        SOAPMessage msg = ctx.getMessage();
        if (msg == null) {
            log.debug("No message - not encrypting.");
            return true;
        }
        log.debug("Enter: encrypt");
        SOAPMessage encryptedMsg = null;
        try {
            SOAPEnvelope clearEnvelope = msg.getSOAPPart().getEnvelope();
            GssEncryptedSOAPEnvelopeBuilder builder = new GssEncryptedSOAPEnvelopeBuilder(ctx, secContext);
            builder.setActor((String)ctx.getProperty("gssActor"));
            encryptedMsg = builder.buildMessage(clearEnvelope);
        }
        catch (Exception e) {
            log.error(i18n.getMessage("encryptErr"), e);
            throw WSSecurityFault.makeFault(e);
        }
        ctx.setMessage(encryptedMsg);
        log.debug("Exit: encrypt");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }
}

