/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.secureconv;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authentication.secureconv.EncryptHandler;
import org.globus.wsrf.impl.security.authentication.secureconv.SignHandler;

public class GSSHandler
extends GenericHandler {
    private static Log log = LogFactory.getLog(GSSHandler.class.getName());
    private SignHandler signHandler;
    private EncryptHandler encHandler;

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        log.debug("Enter: secure");
        Integer msgSecType = (Integer)ctx.getProperty("org.globus.security.secConv.msg.type");
        log.debug("Request msgSecType " + msgSecType);
        if (msgSecType == null) {
            log.debug("No msg security type set.");
            return true;
        }
        if (msgSecType.equals(Constants.SIGNATURE)) {
            if (this.signHandler == null) {
                this.signHandler = new SignHandler();
            }
            this.signHandler.handleMessage(ctx);
        } else if (msgSecType.equals(Constants.ENCRYPTION)) {
            if (this.encHandler == null) {
                this.encHandler = new EncryptHandler();
            }
            this.encHandler.handleMessage(ctx);
        } else if (msgSecType.equals(Constants.NONE)) {
            log.debug("No msg security.");
        } else {
            log.warn("Invalid msg security type.");
        }
        log.debug("Exit: secure");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }
}

