/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.wssec;

import java.security.Key;
import java.security.PrivateKey;
import javax.security.auth.Subject;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignature;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.gsi.proxy.ProxyPathValidator;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityEngine;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.providers.GSSPublicKey;
import org.ietf.jgss.GSSCredential;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSSecurityResponseEngine
extends WSSecurityEngine {
    private static Log log = LogFactory.getLog(WSSecurityResponseEngine.class.getName());
    private static WSSecurityEngine engine;

    public static synchronized WSSecurityEngine getEngine() {
        if (engine == null) {
            engine = new WSSecurityResponseEngine();
        }
        return engine;
    }

    public Document processSecurityHeader(SOAPEnvelope env, MessageContext msgCtx) throws Exception {
        return this.processSecurityHeader(env, msgCtx, false);
    }

    public boolean verifyGssXMLSignature(XMLSignature sig, MessageContext msgContext) throws Exception {
        log.debug("Enter: verifyGssXMLSignature");
        SecurityContext secContext = (SecurityContext)msgContext.getProperty("org.globus.security.secureconv.context");
        if (secContext == null) {
            throw new WSSecurityException(0, "noContext01");
        }
        boolean result = sig.checkSignatureValue((Key)new GSSPublicKey((String)secContext.getID(), secContext.getContext()));
        msgContext.setProperty("org.globus.security.secConv.msg.type", Constants.SIGNATURE);
        log.debug("Exit: verifyGssXMLSignature");
        return result;
    }

    public boolean decryptXMLEncryption(Element element, MessageContext msgCtx) throws Exception {
        this.ensureSignature(msgCtx);
        GSSCredential cred = null;
        Subject subject = JaasSubject.getCurrentSubject();
        if (subject != null) {
            log.debug("Getting credentials from subject");
            cred = JaasGssUtil.getCredential(subject);
        }
        if (cred == null) {
            log.debug("Getting credentials from property");
            cred = AuthUtil.getCredential(msgCtx);
        }
        GlobusCredential credential = null;
        if (cred == null) {
            credential = GlobusCredential.getDefaultCredential();
        } else if (cred instanceof GlobusGSSCredentialImpl) {
            credential = ((GlobusGSSCredentialImpl)cred).getGlobusCredential();
        }
        PrivateKey key = null;
        if (credential != null) {
            key = credential.getPrivateKey();
        }
        if (key == null) {
            throw new WSSecurityException(0, "noCreds");
        }
        msgCtx.setProperty("org.globus.security.secMsg.msg.type", Constants.ENCRYPTION);
        return this.decryptXMLEncryption(element, key);
    }

    public boolean verifyXMLSignature(XMLSignature sig, MessageContext msgCtx) throws Exception {
        ProxyPathValidator validator = new ProxyPathValidator();
        return this.verifyXMLSignature(sig, msgCtx, validator);
    }
}

